package com.yeejoin.amos.boot.module.tcm.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 配套设备/设施/部件
 *
 * @author system_generator
 * @date 2021-11-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tcb_equipment_associated")
public class EquipmentAssociated extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 设备id
     */
	@TableField("equipment_id")
    private Long equipmentId;

    /**
     * 名称
     */
	@TableField("name")
    private String name;

    /**
     * 型号
     */
	@TableField("model")
    private String model;

    /**
     * 规格
     */
	@TableField("specifications")
    private String specifications;

    /**
     * 编号
     */
	@TableField("code")
    private String code;

    /**
     * 数量
     */
	@TableField("amount")
    private Integer amount;

    /**
     * 制造单位
     */
	@TableField("manufacturer")
    private String manufacturer;

    /**
     * 制造日期
     */
	@TableField("production_date")
    private Date productionDate;

    /**
     * 部件/装置号
     */
	@TableField("part_number")
    private String partNumber;

    /**
     * 型式试验合格证号
     */
	@TableField("certificate_number")
    private String certificateNumber;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 鉴定机构名称
     */
	@TableField("appraisal_agency_name")
    private String appraisalAgencyName;

    /**
     * 设计文件鉴定日期
     */
	@TableField("appraisal_date")
    private Date appraisalDate;

    /**
     * 鉴定报告书编号
     */
	@TableField("appraisal_report_number")
    private String appraisalReportNumber;

    /**
     * 监检检验机构
     */
	@TableField("supervisory_inspection_agency")
    private String supervisoryInspectionAgency;

    /**
     * 统一社会信用代码
     */
	@TableField("social_credit_code")
    private String socialCreditCode;

    /**
     * 机构核准证编号
     */
	@TableField("approval_certificate_number")
    private String approvalCertificateNumber;


}
