package com.yeejoin.amos.boot.module.common.biz.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.common.api.dto.FirefightersExcelDto;
import com.yeejoin.amos.boot.module.common.api.dto.FirefightersInfoDto;
import com.yeejoin.amos.boot.module.common.api.dto.FirefightersZhDto;
import com.yeejoin.amos.boot.module.common.api.entity.FirefightersContacts;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.Menu;
import com.yeejoin.amos.boot.biz.common.utils.TreeParser;
import com.yeejoin.amos.boot.module.common.api.dto.FirefightersDto;
import com.yeejoin.amos.boot.module.common.api.entity.Firefighters;
import com.yeejoin.amos.boot.module.common.api.mapper.FirefightersMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFirefightersService;

/**
 * 消防队员 服务实现类
 *
 * @author tb
 * @date 2021-06-07
 */
@Service
public class FirefightersServiceImpl extends BaseService<FirefightersDto, Firefighters, FirefightersMapper> implements IFirefightersService {


    @Autowired
    FirefightersMapper firefightersMapper;
    @Autowired
    DataDictionaryServiceImpl iDataDictionaryService;
    @Autowired
    FirefightersContactsServiceImpl firefightersContactsService;

    @Override
    public List<FirefightersZhDto> getFirefighters(int pageNum, int pageSize, FirefightersDto par) {
        return firefightersMapper.getFirefighters(pageNum, pageSize, par);
    }

    @Override
    public Map<String, Long> getFirefightersCount(int pageNum, int pageSize, FirefightersDto par) {
        // TODO Auto-generated method stub
        return firefightersMapper.getFirefightersCount(pageNum, pageSize, par);
    }

    @Override
    public Map<String, Object> listToSelectById(Long id) {
        // TODO Auto-generated method stub
        return firefightersMapper.listToSelectById(id);
    }

    @Override
    public void saveFirefighters(FirefightersInfoDto firefighters) {
        Firefighters firefighter = firefighters.getFirefighters();
        // 现居住地保存地址信息 户籍所在地信息 BUG3553 bykongfm
        // BUG2168 居住地户籍所在地为空判断 bykongfm
        if(firefighter.getResidenceDetails() != null) {
            FeignClientResult<RegionModel> region =  Systemctl.regionClient.getRegion(Long.parseLong(firefighter.getResidenceDetails()));
            firefighter.setResidence(region.getResult().getRegionName());
        }
        if(firefighter.getNativePlace() != null) {
            FeignClientResult<RegionModel> nativePlace =  Systemctl.regionClient.getRegion(Long.parseLong(firefighter.getNativePlace()));
            firefighter.setNativePlaceValue(nativePlace.getResult().getRegionName());
        }
        save(firefighter);
        FirefightersContacts firefightersContact = firefighters.getFirefightersContacts();
        firefightersContact.setFirefightersId(firefighter.getSequenceNbr());
        firefightersContactsService.save(firefightersContact);
        firefighters.setFirefightersContacts(firefightersContact);
        firefighters.setFirefighters(firefighter);
    }

    @Override
    public Firefighters selectByAmosOrgId(Long id) {

        QueryWrapper<Firefighters> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("amos_user_id",id);
        Firefighters firefighters = firefightersMapper.selectOne(queryWrapper);

        return firefighters;
    }

    /**
     * 导出列表
     */
    public List<FirefightersExcelDto> exportToExcel(@Condition(Operator.eq) Boolean isDelete) {
        return firefightersMapper.exportToExcel(isDelete);
    }


    @Override
    public List<Menu> getFirefightersJobTitleCount() throws Exception {

        QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type", "GWMC");
        queryWrapper.orderByAsc("sort_num");
        Collection<DataDictionary> list = iDataDictionaryService.list(queryWrapper);
        List<Menu> menus = TreeParser.getTree(null, list, DataDictionary.class.getName(), "getCode", 0, "getName",
                "getParent", firefightersMapper.getFirefightersJobTitleCount());
        return menus;
    }


    public List<String> getFirefightersName( ) {

     return     firefightersMapper.getFirefightersName();

    }

}
