package com.yeejoin.amos.boot.module.cylinder.flc.api.dto;

import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 企业人员资质信息表
 *
 * @author system_generator
 * @date 2021-11-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PersonQualityDto", description="企业人员资质信息表")
public class PersonQualityDto extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "org_user_id")
    private Long psersonId;

    @ApiModelProperty(value = "档案编号")
    private String recordNum;

    @ApiModelProperty(value = "证书类型")
    private String licenceType;

    @ApiModelProperty(value = "证书类型编码")
    private String licenceTypeCode;

    @ApiModelProperty(value = "发证机关id")
    private Long licenceIssueOrgId;

    @ApiModelProperty(value = "发证机关")
    private String licenceIssueOrg;

    @ApiModelProperty(value = "作业项目")
    private String projectWork;

    @ApiModelProperty(value = "复审记录")
    private String recheckRecord;

    @ApiModelProperty(value = "聘用记录")
    private String hireRecord;

    @ApiModelProperty(value = "备注")
    private String remark;

 @ApiModelProperty(value = "证书信息")
 private List<AttachmentDto> licenceInfo;

 @ApiModelProperty(value = "发证日期")
 private Date licenceDate;


}
