package com.yeejoin.amos.boot.module.cylinder.biz.core.threadpool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 线程池
 */
public class AmosThreadPool {

    /**
     * 日志记录器
     */
    private static final Logger log = LoggerFactory.getLogger(AmosThreadPool.class);

    /**
     * 单例
     */
    private static AmosThreadPool instance;

    /**
     * 执行服务
     */
    private static ExecutorService executorService;

    /**
     * 获取单例
     *
     * @return
     */
    public static AmosThreadPool getInstance() {
        if (instance == null) {
            synchronized (AmosThreadPool.class) {
                if (instance == null) {
                    instance = new AmosThreadPool();
                }
            }
        }
        return instance;
    }

    static {
        executorService = Executors
                .newFixedThreadPool(20);
    }

    /**
     * 执行线程
     *
     * @param task
     */
    public void execute(Runnable task) {
        executorService.execute(task);
    }

}
