package com.yeejoin.amos.boot.module.jczs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jczs.api.dto.TzBaseUnitLicenceDto;
import com.yeejoin.amos.boot.module.jczs.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.jczs.api.entity.TzBaseUnitLicence;
import com.yeejoin.amos.boot.module.jczs.api.mapper.TzBaseUnitLicenceMapper;
import com.yeejoin.amos.boot.module.jczs.api.service.ITzBaseUnitLicenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.List;

/**
 * 单位许可信息表 服务实现类
 *
 * @author duanwei
 * @date 2022-08-31
 */
@Service
public class TzBaseUnitLicenceServiceImpl extends BaseService<TzBaseUnitLicenceDto, TzBaseUnitLicence, TzBaseUnitLicenceMapper> implements ITzBaseUnitLicenceService {


    @Autowired
    TzBaseEnterpriseInfoServiceImpl baseEnterpriseInfoService;

    public List<TzBaseUnitLicence> getLicenceByCompanyName(List<String> companyNames){
        List<TzBaseUnitLicence> list = new ArrayList<>();
        for(String companyName: companyNames) {
            LambdaQueryWrapper<TzBaseEnterpriseInfo> baseEnterpriseInfoWrap = new LambdaQueryWrapper<>();
            LambdaQueryWrapper<TzBaseUnitLicence> baseUnitLicenceWrap = new LambdaQueryWrapper<>();
            baseEnterpriseInfoWrap.eq(TzBaseEnterpriseInfo::getUseUnit, companyName);
            TzBaseEnterpriseInfo baseEnterpriseInfo;
            try {
                baseEnterpriseInfo = baseEnterpriseInfoService.getOne(baseEnterpriseInfoWrap);
            } catch (Exception e) {
                continue;
            }
            if (ValidationUtil.isEmpty(baseEnterpriseInfo)) {
                continue;
            }
            String unitCode = baseEnterpriseInfo.getUseCode();
            if (ValidationUtil.isEmpty(unitCode)) {
                continue;
            }
            baseUnitLicenceWrap.eq(TzBaseUnitLicence::getUnitCode, unitCode);
            List<TzBaseUnitLicence> unitLicenceList = this.list(baseUnitLicenceWrap);
            list.addAll(unitLicenceList);
        }
        return list;
    }

    public List<TzBaseUnitLicence> getLicenceByUnitCode(String unitCode) {
        LambdaQueryWrapper<TzBaseEnterpriseInfo> wrap = new LambdaQueryWrapper<>();
        wrap.eq(TzBaseEnterpriseInfo::getUseCode,unitCode);
        List<TzBaseEnterpriseInfo> tzBaseEnterpriseInfoList = baseEnterpriseInfoService.list(wrap);
        List<String> companyNames = new ArrayList<>();
        if(ValidationUtil.isEmpty(tzBaseEnterpriseInfoList)){
            return new ArrayList<>();
        }
        for (TzBaseEnterpriseInfo tzBaseEnterpriseInfo: tzBaseEnterpriseInfoList) {
            String companyName = tzBaseEnterpriseInfo.getUseUnit();
            companyNames.add(companyName);
        }
        return getLicenceByCompanyName(companyNames);
    }
}
