package com.yeejoin.amos.boot.module.jg.api.service;

import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.ReportAnalysisSearchDTO;
import com.yeejoin.amos.boot.module.jg.api.vo.JgBizCountBaseVo;
import com.yeejoin.amos.boot.module.jg.api.vo.JgBizEquipStateCountVo;

import java.util.List;
import java.util.Map;

public interface IReportAnalysisService {
    /**
     * 告知类统计列表
     * @param reportAnalysisSearchDTO 检索条件
     * @return List<JgBizCountBaseVo>
     */
    List<JgBizCountBaseVo> getNoticeCountList(ReportAnalysisSearchDTO reportAnalysisSearchDTO);

    /**
     * 登记类统计列表
     * @param reportAnalysisSearchDTO 检索条件
     * @return List<JgBizCountBaseVo>
     */
    List<JgBizCountBaseVo> getRegisterCountList(ReportAnalysisSearchDTO reportAnalysisSearchDTO);

    /**
     * 维保备案业务办理设备情况统计表
     * @param reportAnalysisSearchDTO 检索条件
     * @return List<JgBizCountBaseVo>
     */
    List<JgBizCountBaseVo> getMaintenanceCountList(ReportAnalysisSearchDTO reportAnalysisSearchDTO);

    /**
     * 设备状态情况统计表
     * @param reportAnalysisSearchDTO 检索条件
     * @return List<JgBizCountBaseVo>
     */
    List<JgBizEquipStateCountVo> getEquipStatusCountList(ReportAnalysisSearchDTO reportAnalysisSearchDTO);

    /**
     * 查询当前登录人的管辖机构树，显示本级级所有下级
     * @param selectedOrgInfo 登录人信息
     * @param isReg 是否需要转换为登记机关
     * @return  List<CompanyBo>
     */
    List<CompanyBo> getReceiveCompanyTreeWithAuth(ReginParams selectedOrgInfo, boolean isReg);

    /**
     * 业务类型枚举
     * @param groupKey 分组
     * @return  List<Map<String, Object>>
     */
    List<Map<String, Object>> getBizTypeList(String groupKey);
}
