package com.yeejoin.amos.boot.module.statistics.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 自定义筛选字段基础数据表
 *
 * @author system_generator
 * @date 2025-06-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="TzsCustomFilterDto", description="自定义筛选字段基础数据表")
public class TzsCustomFilterDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "是否快捷筛选（是：1，否：0）")
    private String fastFilter;

    @ApiModelProperty(value = "业务类型（设备：equip，企业：company，人员：person）")
    private String filterBusinessType;

    @ApiModelProperty(value = "筛选字段code（对应业务数据筛选字段）")
    private String filterFieldCode;

    @ApiModelProperty(value = "筛选字段名称（对应业务数据筛选字段名）")
    private String filterFieldName;

    @ApiModelProperty(value = "筛选值code（对应业务数据筛选字段枚举值）")
    private String filterValueCode;

    @ApiModelProperty(value = "筛选值名称（对应业务数据筛选字段枚举名称）")
    private String filterValueName;

    @ApiModelProperty(value = "父节点Id")
    private String parentId;

    @ApiModelProperty(value = "过滤类型（大于：gt，大于等于：ge，小于：lt，小于等于：le，介于：bt，等于：eq，不等于：ne，匹配：like，在列表中：in，不在列表中：not_in）")
    private String operatorType;

    @ApiModelProperty(value = "备注1")
    private String remark1;

    @ApiModelProperty(value = "备注2")
    private String remark2;

}
