package com.yeejoin.amos.boot.module.tcm.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tcm.api.dto.RiskReportDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.RiskReport;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Map;

/**
 * 风险报送表 Mapper 接口
 *
 * @author system_generator
 * @date 2025-08-08
 */
public interface RiskReportMapper extends BaseMapper<RiskReport> {

    Page<Map<String, String>> allAgencyWithPage(@Param("page") Page<Map<String, String>> page,
                                                @Param("isAdmin") boolean isAdmin,
                                                @Param("companyName") String companyName);

    Page<RiskReport> queryForRiskReportPage(@Param("page") Page<RiskReport> page,
                                            @Param("dto") RiskReportDto reportDto);

    Map<String, String> getCompanyBySeq(@Param("companySeq") String companySeq);

    @Select("select all_risk_disposal_unit_org_code from tzs_risk_report where sequence_nbr = #{sequenceNbr}")
    String getAllRiskDisposalUnitOrgCode(Long sequenceNbr);
}
