package com.yeejoin.amos.boot.module.tcm.biz.controller;

import com.yeejoin.amos.boot.module.tcm.biz.service.impl.HisDataHandlerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@RequestMapping(value = "/hisData")
@Api(tags = "历史数据处理")
@RequiredArgsConstructor
public class HisDataHandlerController {

    private final HisDataHandlerServiceImpl hisDataHandlerService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "检验检测开通历史数据处理-将企业的管理员增加到检验机构或者检测机构用户组")
    @PutMapping(value = "/v1/addAdminUser2JyjcGroup")
    public ResponseModel<Long> addAdminUser2JyjcGroup() {
        return ResponseHelper.buildResponse(hisDataHandlerService.addAdminUser2JyjcGroup());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "检验检测开通历史数据处理-将企业的业务办理人员且已经开通账号的增加到检验机构业务办理人员或者检测业务办理人员用户组")
    @PutMapping(value = "/v1/addBizUser2NewBizGroup")
    public ResponseModel<Long> addBizUser2NewBizGroup() {
        return ResponseHelper.buildResponse(hisDataHandlerService.addBizUser2NewBizGroup());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "检验检测开通历史数据处理-将企业的单位类型由检验检测机构改为检验机构或者检测机构")
    @PutMapping(value = "/v1/companyType/update")
    public ResponseModel<Long> companyTypeUpdate() {
        return ResponseHelper.buildResponse(hisDataHandlerService.companyTypeUpdate());
    }
}
