package com.yeejoin.amos.patrol.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum TaskStatisticsTypeEnum {
	 EXECUTOR("执行人",0),
	 INSPECTORS("巡检人员",1),
	 ROUTE("巡检路线",2),
	 POINT("巡检点",3),
	 DEPARTMENT("巡检部门",4),
	 PLAN("巡检计划",5),
	 TASKMONTH("任务日期",6),
	 TASTTIME("任务月份",7);
	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private int value;
	


	private TaskStatisticsTypeEnum(String name, int value) {
		this.name = name;
		this.value = value;
	}


	public static String getName(int value) {
		for (TaskStatisticsTypeEnum c : TaskStatisticsTypeEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	public static int getValue(String name) {
		for (TaskStatisticsTypeEnum c : TaskStatisticsTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return -1;
	}


	public static TaskStatisticsTypeEnum getEnum(int value) {
		for (TaskStatisticsTypeEnum c : TaskStatisticsTypeEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}


	public static TaskStatisticsTypeEnum getEnum(String name) {
		for (TaskStatisticsTypeEnum c : TaskStatisticsTypeEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (TaskStatisticsTypeEnum c: TaskStatisticsTypeEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("value", c.getValue() +"");
			nameList.add(map);
		}
		return nameList;
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public int getValue() {
		return value;
	}


	public void setValue(int value) {
		this.value = value;
	}
}
