package com.yeejoin.amos.patrol.dao.entity;

import com.baomidou.mybatisplus.annotation.TableName;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 * The persistent class for the p_point_inputitem database table.
 * 
 */
@Entity
@Table(name="p_point_inputitem")
@TableName("p_point_inputitem")
@NamedQuery(name="PointInputItem.findAll", query="SELECT p FROM PointInputItem p")
public class PointInputItem extends BasicEntity{
	private static final long serialVersionUID = 1L;

	/**
	 * 巡检点id
	 */
	@Column(name="classify_ids")
	private String classifyIds;

	/**
	 * 点分类id集合
	 */
	@Column(name="input_item_id")
	private long inputItemId;

	/**
	 * 巡检项id
	 */
	@Column(name="point_id")
	private long pointId;
	
	/**
	 * 排序编码
	 */
	@Column(name="order_no")
	private int orderNo;

	public PointInputItem() {
	}

	public String getClassifyIds() {
		return this.classifyIds;
	}

	public void setClassifyIds(String classifyIds) {
		this.classifyIds = classifyIds;
	}

	public long getInputItemId() {
		return this.inputItemId;
	}

	public void setInputItemId(long inputItemId) {
		this.inputItemId = inputItemId;
	}

	public long getPointId() {
		return this.pointId;
	}

	public void setPointId(long pointId) {
		this.pointId = pointId;
	}

	public int getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(int orderNo) {
		this.orderNo = orderNo;
	}

}