package com.yeejoin.amos.boot.module.ymt.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 装备信息表
 *
 * @author system_generator
 * @date 2021-11-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tcb_equipment")
public class Equipment extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 设备id
     */
	@TableField("equip_id")
    private String equipId;

    /**
     * 设备编号
     */
	@TableField("code")
    private String code;

    /**
     * 设备名称
     */
	@TableField("name")
    private String name;

    /**
     * 设备类别id
     */
	@TableField("category_id")
    private Long categoryId;

    /**
     * 设备类别名称
     */
	@TableField("category_name")
    private String categoryName;

    /**
     * 设备种类id
     */
	@TableField("type_id")
    private Long typeId;

    /**
     * 设备种类名称
     */
	@TableField("type_name")
    private String typeName;

    /**
     * 设备品种id
     */
	@TableField("variety_id")
    private Long varietyId;

    /**
     * 设备品种名称
     */
	@TableField("variety_name")
    private String varietyName;

    /**
     * 设备品牌
     */
	@TableField("brand")
    private String brand;

    /**
     * 规格型号
     */
	@TableField("model")
    private String model;

    /**
     * 单位内部编号
     */
	@TableField("inner_code")
    private String innerCode;

    /**
     * 设计单位名称
     */
	@TableField("design_unit_name")
    private String designUnitName;

    /**
     * 制造单位名称
     */
	@TableField("manufacturer")
    private String manufacturer;

    /**
     * 设计使用年限
     */
	@TableField("design_life")
    private Integer designLife;

    /**
     * 出厂日期
     */
	@TableField("factory_date")
    private Date factoryDate;

    /**
     * 产品编号（出厂编号）
     */
	@TableField("product_code")
    private String productCode;

    /**
     * 监督检验机构
     */
	@TableField("supervision_agency")
    private String supervisionAgency;

    /**
     * 检验报告编号
     */
	@TableField("inspection_report_code")
    private String inspectionReportCode;

    /**
     * 设备状态（未安装，已安装）
     */
	@TableField("status")
    private String status;

    /**
     * 设备所属单位id
     */
    @TableField("equip_unit_id")
    private Long equipUnitId;

    /**
     * 设备所属单位
     */
    @TableField("equip_unit")
    private String equipUnit;

    /**
     * 详细地址
     */
    @TableField("address")
    private String address;

    /**
     * 经度
     */
    @TableField("longitude")
    private String longitude;

    /**
     * 纬度
     */
    @TableField("latitude")
    private String latitude;

    /**
     * 所属区域代码
     */
    @TableField("region_code")
    private String regionCode;


}
