package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 经销商人员信息
 *
 * @author system_generator
 * @date 2023-07-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="UnitInfoDto", description="经销商人员信息")
public class UnitInfoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "企业名称")
    private String name;

    @ApiModelProperty(value = "注册地址")
    private String registerAddress;

    @ApiModelProperty(value = "工作地址")
    private String workAddress;

    @ApiModelProperty(value = "负责人名称")
    private String headName;

    @ApiModelProperty(value = "负责人电话")
    private String headPhone;

    @ApiModelProperty(value = "负责人身份证号码")
    private String headIdNumber;

    @ApiModelProperty(value = "负责人身份证照片正面")
    private String headCardPhotoFront;

    @ApiModelProperty(value = "负责人身份证照片反面")
    private String headCardPhotoBack;

    @ApiModelProperty(value = "管理员账户名")
    private String adminLoginName;

    @ApiModelProperty(value = "管理员电话")
    private String adminPhone;

    @ApiModelProperty(value = "管理员密码")
    private String adminLoginPwd;

    @ApiModelProperty(value = "管理员平台用户id")
    private String adminUserId;

    @ApiModelProperty(value = "平台公司id")
    private Long amosCompanySeq;

    @ApiModelProperty(value = "上级单位id")
    private Long parentUnitId;

    @ApiModelProperty(value = "角色id")
    private String roleId;

}
