package com.yeejoin.amos.boot.module.jg.api.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.JgReformNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgReformNotice;
import java.util.List;
import java.util.Map;

/**
 * 改造告知接口类
 *
 * @author system_generator
 * @date 2023-12-19
 */
public interface IJgReformNoticeService extends IService<JgReformNotice> {

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return 改造告知
     */
    Map<String, Object> queryBySequenceNbr(Long sequenceNbr);

    /**
     * 更新改造告知
     *
     * @param noticeDto 改造告知
     * @param op        操作类型
     */
    JgReformNoticeDto updateInstallationNotice(String submitType, JgReformNoticeDto noticeDto, String op);

    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 改造告知列表
     */
    Page<JgReformNoticeDto> queryForJgReformNoticePage(Page<JgReformNotice> page, JgReformNoticeDto model, String type, ReginParams reginParams);

    /**
     * 批量删除
     *
     * @param sequenceNbrs 主键
     * @return 是否删除成功
     */
    Boolean deleteForBatch(Long[] sequenceNbrs);

    /**
     * 保存改造告知单
     *
     * @param model      数据
     * @param submitType 保存类型
     */
    List<JgReformNotice> saveNotice(String submitType, Map<String, Object> model, ReginParams reginParams);

    /**
     * 打印告知单
     *
     * @param sequenceNbr 主键
     * @return pdf文件路径
     */
    String generateInstallationNoticeReport(Long sequenceNbr);
}
