package com.yeejoin.amos.api.openapi.face.model;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.model.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
/**
 * 
 * <pre>
 * 电梯 model
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorModel.java, v 0.1 2021年9月30日 下午3:28:02 gwb Exp $
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ElevatorModel extends BaseModel {

        /**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = 3878194701154483320L;
	
		/**
         * 主键
         */
    private Long sequenceNbr;
        /**
         * 电梯应急救援识别码
         */
    private Integer rescueCode;
        /**
         * 设备注册代码
         */
    private String registerCode;
        /**
         * 所属省
         */
    private String province;
        /**
         * 所属地市
         */
    private String city;
        /**
         * 所属区县
         */
    private String district;
        /**
         * 所属区域代码
         */
    private String regionCode;
        /**
         * 安装地址
         */
    private String address;
        /**
         * 经度
         */
    private String longitude;
        /**
         * 纬度
         */
    private String latitude;
        /**
         * 内部编号
         */
    private String innerNum;
        /**
         * 电梯品牌
         */
    private String brand;
        /**
         * 出厂编号
         */
    private String factoryNum;
        /**
         * 电梯安装单位
         */
    private String installationUnit;
        /**
         * 制造日期（出厂时间）
         */
    private Date factoryDate;
        /**
         * 电梯大修/改造日期
         */
    private Date overhaulDate;
        /**
         * 开始使用日期
         */
    private Date startUseDate;
        /**
         * 设备类别
         */
    private String category;
        /**
         * 使用场所分类
         */
    private String useSiteCategory;
        /**
         * 电梯型号
         */
    private String model;
        /**
         * 电梯层数
         */
    private Integer floors;
        /**
         * 电梯站数
         */
    private Integer stations;
        /**
         * 电梯门数
         */
    private Integer doors;
        /**
         * 电梯额定速度(单位：m/s)
         */
    private Float ratedSpeed;
        /**
         * 电梯额定载重量(单位：kg)
         */
    private Float ratedLoad;
        /**
         * 最大荷载人数
         */
    private Integer maxPersonLoad;
        /**
         * 提升高度（单位m）
         */
    private Float raiseHeight;
        /**
         * 拖动方式
         */
    private String dragMode;
        /**
         * 电梯使用状态
         */
    private Integer useStatus;
        /**
         * 使用单位
         */
    private String useUnit;
        /**
         * 使用单位id
         */
    private Long useUnitId;
        /**
         * 制造单位名称
         */
    private String manufacturerName;
        /**
         * 制造许可编号
         */
    private String manufacturingLicense;
        /**
         * 维护周期
         */
    private String maintainPeriod;
        /**
         * 维保类型
         */
    private String maintainType;
        /**
         * 维保单位
         */
    private String maintainUnit;
        /**
         * 维保单位id
         */
    private Long maintainUnitId;
        /**
         * 维保负责人
         */
    private String maintainLeader;
        /**
         * 维保负责人id
         */
    private Long maintainLeaderId;
        /**
         * 维保负责人手机
         */
    private String maintainLeaderPhone;
        /**
         * 主机模式
         */
    private String hostModel;
        /**
         * 主机编号
         */
    private String hostNum;
        /**
         * 动力类型
         */
    private String engineType;
        /**
         * 动力编号
         */
    private String engineNum;
        /**
         * 面板模型
         */
    private String panelModel;
        /**
         * 面板编号
         */
    private String panelNum;
        /**
         * 级联模型
         */
    private String cascadeModel;
        /**
         * 级联线路模型
         */
    private String cascadeLineModel;
        /**
         * 扶手带类型
         */
    private String handrailType;
        /**
         * 扶手面板模型
         */
    private String handrailPanelModel;
        /**
         * 扶手面板品牌
         */
    private String handrailPanelBrand;
        /**
         * 滚转机模式
         */
    private String rollerMode;
        /**
         * 倾斜的角度
         */
    private String tiltAngle;
        /**
         * 横向跨度
         */
    private String horizontalSpan;
        /**
         * 运行噪音
         */
    private String runningNoise;
        /**
         * 运行方式
         */
    private String runningMode;
        /**
         * 运行振动
         */
    private String runningVibration;
        /**
         * 功率
         */
    private String power;
        /**
         * 原始表id（来自历史数据库）
         */
    private String originalId;
        /**
         * 是否删除（1：已删除，0：未删除）
         */
    private Boolean isDelete;
        /**
         * 更新日期
         */
    private Date recDate;
        /**
         * 更新人员id
         */
    private String recUserId;
        /**
         * 更新人员名称
         */
    private String recUserName;
        /**
         * 检验报告编号
         */
    private String inspectionReportNo;
        /**
         * 检验时间
         */
    private Date inspectionDate;
        /**
         * 下次检验时间
         */
    private Date nextInspectionTime;
        /**
         * 检验单位
         */
    private String inspectionUnitName;
        /**
         * 使用单位主管机构
         */
    private String useUnitAuthority;

}
