package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/9/1
 */
@Data
public class CommerceDto {
    protected Long sequenceNbr;
    @ApiModelProperty(value = "统一信用代码")
    private String creditCode;

    @ApiModelProperty(value = "营业执照")
    private List<FileDto> businessLicensePhotoUrl;
    private String businessLicensePhoto;

    @ApiModelProperty(value = "法人名字")
    private String legalPersonName;

    @ApiModelProperty(value = "法人身份证号")
    private String legalPersonIdNumber;

    @ApiModelProperty(value = "法人身份证照片正面")
    private List<FileDto> legalPersonCardPhotoFrontUrl;
    private String legalPersonCardPhotoFront;
    @ApiModelProperty(value = "法人身份证照片反面")
    private List<FileDto> legalPersonCardPhotoBackUrl;
    private String legalPersonCardPhotoBack;
    @ApiModelProperty(value = "法人联系方式")
    private String legalPersonPhone;


    public void setBusinessLicensePhotoUrl(List<FileDto> businessLicensePhotoUrl) {
        String url=null;
        if(businessLicensePhotoUrl!=null&&!businessLicensePhotoUrl.isEmpty()&&!businessLicensePhotoUrl.isEmpty()){
            url=businessLicensePhotoUrl.get(0).getUrl();
        }
        this.businessLicensePhoto=url;
        this.businessLicensePhotoUrl = businessLicensePhotoUrl;
    }

    public void setBusinessLicensePhoto(String businessLicensePhoto) {
        if(this.businessLicensePhoto!=null&&!businessLicensePhoto.isEmpty()&&this.businessLicensePhotoUrl==null){
            List<FileDto> businessLicensePhotoUrl =new ArrayList<>();
            FileDto d=new FileDto(this.businessLicensePhoto);
            businessLicensePhotoUrl.add(d);
            this.businessLicensePhotoUrl =businessLicensePhotoUrl;
        }
        this.businessLicensePhoto = businessLicensePhoto;
    }

    public void setLegalPersonCardPhotoFrontUrl(List<FileDto> legalPersonCardPhotoFrontUrl) {
        String url=null;
        if(legalPersonCardPhotoFrontUrl!=null&&!legalPersonCardPhotoFrontUrl.isEmpty()&&!legalPersonCardPhotoFrontUrl.isEmpty()){
            url=legalPersonCardPhotoFrontUrl.get(0).getUrl();
        }
        this.legalPersonCardPhotoFront=url;
        this.legalPersonCardPhotoFrontUrl = legalPersonCardPhotoFrontUrl;
    }

    public void setLegalPersonCardPhotoFront(String legalPersonCardPhotoFront) {
        if(this.legalPersonCardPhotoFront!=null&&!this.legalPersonCardPhotoFront.isEmpty()&&this.legalPersonCardPhotoFrontUrl==null){
            List<FileDto> legalPersonCardPhotoFrontUrl =new ArrayList<>();
            FileDto d=new FileDto(this.legalPersonCardPhotoFront);
            legalPersonCardPhotoFrontUrl.add(d);
            this.legalPersonCardPhotoFrontUrl =legalPersonCardPhotoFrontUrl;
        }
        this.legalPersonCardPhotoFront = legalPersonCardPhotoFront;
    }

    public void setLegalPersonCardPhotoBackUrl(List<FileDto> legalPersonCardPhotoBackUrl) {
        String url=null;
        if(legalPersonCardPhotoBackUrl!=null&&!legalPersonCardPhotoBackUrl.isEmpty()&&!legalPersonCardPhotoBackUrl.isEmpty()){
            url=legalPersonCardPhotoBackUrl.get(0).getUrl();
        }
        this.legalPersonCardPhotoBack=url;
        this.legalPersonCardPhotoBackUrl = legalPersonCardPhotoBackUrl;
    }

    public void setLegalPersonCardPhotoBack(String legalPersonCardPhotoBack) {
        if(this.legalPersonCardPhotoBack!=null&&!this.legalPersonCardPhotoBack.isEmpty()&& this.legalPersonCardPhotoBackUrl==null){
            List<FileDto> legalPersonCardPhotoBackUrl =new ArrayList<>();
            FileDto d=new FileDto(this.legalPersonCardPhotoBack);
            legalPersonCardPhotoBackUrl.add(d);
            this.legalPersonCardPhotoBackUrl =legalPersonCardPhotoBackUrl;
        }
        this.legalPersonCardPhotoBack = legalPersonCardPhotoBack;
    }
}
