package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.module.common.api.entity.SourceFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 维保合同
 *
 * @author system_generator
 * @date 2021-07-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ContractDto", description = "维保合同")
public class ContractDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "合同名称")
    private String name;

    @ApiModelProperty(value = "签订单位名称")
    private String signedCompany;

    @ApiModelProperty(value = "签订单位id")
    private Long signedCompanyId;

    @ApiModelProperty(value = "合同开始日期")
    private Date beginDate;

    @ApiModelProperty(value = "合同结束日期")
    private Date endDate;

    @ApiModelProperty(value = "签订日期")
    private Date signedDate;

    @ApiModelProperty(value = "合同编号")
    private String contractNo;

    @ApiModelProperty(value = "机构代码用于权限过滤")
    private String orgCode;

    @ApiModelProperty(value = "单位名称")
    private String company;

    @ApiModelProperty(value = "单位id")
    private Long companyId;

    @ApiModelProperty(value = "更新人名称")
    private String recUserName;

    @ApiModelProperty(value = "单位类型（1维保单位，0联动单位）")
    private String companyType;

    @ApiModelProperty(value = "合同类型code")
    private String typeCode;

    @ApiModelProperty(value = "合同类型")
    private String type;

    @ApiModelProperty(value = "服务内容")
    private String serviceContent;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "合同附件")
    private String contractAttachment;

    @ApiModelProperty(value = "附件")
    private List<SourceFile> attachment;
}
