package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationManageDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationManage;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.CertificateVo;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import java.util.List;
import java.util.Map;


/**
 *  Mapper 接口
 *
 * @author system_generator
 * @date 2024-07-03
 */
public interface JgUseRegistrationManageMapper extends BaseMapper<JgUseRegistrationManage> {

    List<JgUseRegistrationManageDto> queryByUseUnitCreditCode(@Param("dto") JgUseRegistrationManageDto dto);

    Page<JgUseRegistrationManageDto> queryForPage(@Param("page") Page<JgUseRegistrationManageDto> page,
                                           @Param("dto") JgUseRegistrationManageDto dto,
                                           @Param("sort") SortVo sortMap);

    Long countCertificateByReginCode(String orgCode);

    Page<JgUseRegistrationManageDto> getRecords(@Param("page") Page<JgUseRegistrationManageDto> page,
                                                @Param("dto") JgUseRegistrationManageDto dto,
                                                @Param("orgCode") String orgCode);

    List<CertificateVo> queryCertificateInIds(@Param("ids") List<String> ids);

    @MapKey("year")
    List<Map<String, String>> initUseRegistrationCodeIntoRedis(@Param("year") String year);
}
