package com.yeejoin.amos.boot.module.app.api.dto;


import com.yeejoin.amos.boot.module.app.api.annotation.ChargeMediaConverter;
import com.yeejoin.amos.boot.module.app.api.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.module.app.api.annotation.InspectResultConverter;
import lombok.Data;

@Data
public class CylinderInfoForWX {
    private String record;

    @FieldDisplayDefine(value = "设备品种")
    private String equDefine;

    @FieldDisplayDefine(value = "产品编号")
    private String factoryNum;

    @FieldDisplayDefine(value = "设备代码")
    private String equCode;

    @FieldDisplayDefine(value = "制造单位")
    private String produceUnitName;

    @FieldDisplayDefine(value = "制造年月", alias="produceDateStr")
    private String produceDate;

    @FieldDisplayDefine(value = "充装介质", converter = ChargeMediaConverter.class)
    private String chargingMedium;

    @FieldDisplayDefine(value = "公称工作压力（MPa）")
    private String nominalWorkingPressure;

    @FieldDisplayDefine(value = "容积（L）")
    private String singleBottleVolume;

    @FieldDisplayDefine(value = "最近一次检验日期", alias="lastInspectDateStr")
    private String lastInspectDate;

    @FieldDisplayDefine(value = "下次检验日期", alias="nextInspectDateStr")
    private String nextInspectDate;

    @FieldDisplayDefine(value = "检验结果" ,converter = InspectResultConverter.class)
    private String inspectConclusion;
}
