package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgEquipTransferMapper;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@Component
@Slf4j
public class EquipTransferEquipUsedCheckImpl extends BaseEquipUsedCheckService {

    private final RedissonClient redissonClient;

    private final String bizType = "equipmentHandover";

    private final JgEquipTransferMapper equipTransferMapper;

    public EquipTransferEquipUsedCheckImpl(RedissonClient redissonClient, JgEquipTransferMapper equipTransferMapper) {
        this.redissonClient = redissonClient;
        this.equipTransferMapper = equipTransferMapper;
    }


    @Override
    public RedissonClient getRedisClient() {
        return redissonClient;
    }

    @Override
    public String getApplyBizType() {
        return bizType;
    }


    @Override
    public void init() {
        // 初始化在流程中的设备数据
        List<CompanyEquipCountDto> companyEquipCountDtos = equipTransferMapper.queryForFlowingEquipList();
        companyEquipCountDtos.remove(null);
        companyEquipCountDtos.forEach(c -> {
            RBucket<Set<String>> rBucket = redissonClient.getBucket(getFlowingEquipRedisKey(c.getCompanyCode(), bizType));
            rBucket.set(Arrays.stream(c.getRecords().split(",")).collect(Collectors.toSet()));
        });
    }
}
