package com.yeejoin.amos.boot.biz.common.workflow.feign;

import java.util.HashMap;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.alibaba.fastjson.JSONObject;

import feign.Response;

@FeignClient(name = "AMOS-API-WORKFLOW", path = "workflow", configuration = { CommonMultipartSupportConfig.class })
public interface WorkflowFeignService {
	/**
	 * 发起流程
	 *
	 * @param params
	 * @return
	 */
	@RequestMapping(value = "/task/startProcess", method = RequestMethod.POST)
	JSONObject startByVariable(@RequestBody Object params);

	/**
	 * 完成任务
	 *
	 * @param taskID
	 * @param variable
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/task/pickupAndCompleteTask/noFromInstanceAdd/{taskId}", method = RequestMethod.POST)
	JSONObject pickupAndCompleteTask(@PathVariable("taskId") String taskID,
			@RequestBody(required = false) HashMap<String, Object> variable) throws Exception;

	/**
	 * 查询当前流程下所有的可执行任务
	 *
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/task/list/all/{processInstanceId}", method = RequestMethod.GET)
	JSONObject getTaskList(@PathVariable("processInstanceId") String processInstanceId);

	/**
	 * 查询当前任务的执行用户组
	 *
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/task/getTaskGroupName/{taskId}", method = RequestMethod.GET)
	JSONObject getTaskGroupName(@PathVariable("taskId") String taskId);

	/**
	 * 我的待办
	 * @param processDefinitionKey
	 * @param userId
	 * @return
	 */
	@RequestMapping(value = "/task/all-list", method = RequestMethod.GET)
	 JSONObject getTasksNoAuth(@RequestParam(value="processDefinitionKey", required=false)  String processDefinitionKey,
	    		@RequestParam(value="userId", required=false)  String userId) ;
	/**
	 * 流程信息
	 * @param processDefinitionKey
	 * @param userId
	 * @return
	 */
	@RequestMapping(value = "/activitiHistory/processes/historytasks/list/{processInstanceId}", method = RequestMethod.GET)
	 JSONObject queryHistoryTaskListByProcessId(@PathVariable("processInstanceId") String processInstanceId);
	/**
	 * 查询当前流程已经执行的任务
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/activitiHistory/historyTask/{processInstanceId}", method = RequestMethod.GET)
	JSONObject queryHistoryTasksByProcessInstanceId(@PathVariable("processInstanceId") String processInstanceId);
	/**
	 * 拾取任务
	 * @param taskID
	 * @return
	 */
	@RequestMapping(value = "/task/pickuptask/{taskID}", method = RequestMethod.PUT)
	JSONObject pickuptask(@PathVariable("taskID") String taskID) ;
	/**
	 * 直接完成任务
	 * @param taskId
	 * @param variable
	 * @return
	 */
	@RequestMapping(value = "/task/complete/{taskId}", method = RequestMethod.POST)
	JSONObject completeByVariable(@PathVariable("taskId") String taskId, @RequestBody HashMap<String, Object> variable);
	
	@RequestMapping(value = "/task/getTaskAssign/{taskId}", method = RequestMethod.GET)
	JSONObject getTaskAssign(@PathVariable("taskId") String taskId) ;
	/**
	 * 不操作FormInstance直接完成任务
	 * @param taskID
	 * @param variable
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/task/completeTask/noFromInstanceAdd/{taskID}", method = RequestMethod.POST)
	JSONObject completeNoExecuteFromInstanceAdd(@PathVariable("taskID") String taskID, @RequestBody(required = false) HashMap<String, Object> variable) throws Exception;

/**
 * 流程图高亮
 * */
	@RequestMapping(value = "/activitiHistory/gethighLineImg/{processInstanceId}", method = RequestMethod.GET)
	Response thighLineImg(@PathVariable("processInstanceId") String processInstanceId) ;
/**
 * 流程图高亮图片
 * */
	@RequestMapping(value = "/activitiHistory/gethighLine",method = RequestMethod.GET)
	Response thighLine(@RequestParam("instanceId") String instanceId);
}
