package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 安全追溯-维保备案信息表
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MidEquipMaintenanceRecordInfoDto", description="安全追溯-维保备案信息表Dto")
public class MidMaintenanceInfoModel extends AbstractBaseModel {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "$column.comments")
    private String supervisoryCode;

    @ApiModelProperty(value = "$column.comments")
    private String instanceId;
    @ApiModelProperty(value = "$column.comments")
    private String status;
    @ApiModelProperty(value = "维保单位统一社会信用代码")
    private String meUnitCreditCode;
    @ApiModelProperty(value = "维保单位名称")
    private String meUnitName;
    @ApiModelProperty(value = "维保备案合同")
    private String repairInform;
    @ApiModelProperty(value = "维保合同开始日期")
    private Date informStart;
    @ApiModelProperty(value = "维保合同结束日期")
    private Date informEnd;
    @ApiModelProperty(value = "维保负责人姓名")
    private String meMaster;
    @ApiModelProperty(value = "维保负责人身份证")
    private String meMasterId;
    @ApiModelProperty(value = "紧急救援电话")
    private String emergencycall;
    @ApiModelProperty(value = "维保周期")
    private String meCycle;
    @ApiModelProperty(value = "大修周期")
    private String overhaulCycle;
    @ApiModelProperty(value = "24小时维保电话")
    private String me24Telephone;
    @ApiModelProperty(value = "设备的唯一标识")
    private String sequenceCode;


}
