package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum IsSupervisoryCodeEnum {

    /**
     * *赋码状态
     */

    WFM("未赋码", "0"),
    YFM("已赋码", "1"),
    ;

    private String name;
    private String code;

    public static Map<String, String> getName = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();


    static {
        for (IsSupervisoryCodeEnum e : IsSupervisoryCodeEnum.values()) {
            getName.put(e.code, e.name);
            getCode.put(e.name, e.code);
        }
    }

    public static JSONArray getAll(){
        JSONArray jsonArray = new JSONArray();
        for (IsSupervisoryCodeEnum e : IsSupervisoryCodeEnum.values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label",e.name);
            jsonObject.put("value",e.name);
            jsonObject.put("key",e.code);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }
}
