package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.IBaseChangeData;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 注册登记信息表
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("idx_biz_jg_register_info")
@Group(value = "idx_biz_jg_register_info")
public class IdxBizJgRegisterInfo extends TzsBaseEntity implements IBaseChangeData {




    /**
     *
     */
    @TableField("\"RECORD\"")
    private String record;


    /**
     *
     */
    @TableField("\"INSTANCE_ID\"")
    private String instanceId;

    /**
     *
     */
    @TableField("\"STATUS\"")
    private String status;

    /**
     *
     */
    @TableField("\"ORGANIZATION_CODE\"")
    private String organizationCode;

    /**
     *
     */
    @TableField("\"ORGANIZATION_NAME\"")
    private String organizationName;

    /**
     *
     */
    @TableField("\"USE_ORG_CODE\"")
    @FieldDisplayDefine(value = "使用登记证编号")
    private String useOrgCode;

    /**
     *
     */
    @TableField("\"REGISTER_STATE\"")
    private String registerState;


    /**
     * 设备代码类型手工输入（1）、系统自动生成（2）
     */
    @TableField("\"EQU_CODE_TYPE\"")
    @FieldDisplayDefine(value = "设备代码类型", typeHandler = "hasOrNoTypeHandler")
    private String equCodeType;


    /**
     * 设备代码
     */
    @TableField("\"EQU_CODE\"")
    @FieldDisplayDefine(value = "设备代码")
    private String equCode;

    /**
     *
     */
    @TableField("\"EQU_LIST\"")
    private String equList;

    /**
     *
     */
    @TableField("\"EQU_CATEGORY\"")
    private String equCategory;

    /**
     *
     */
    @TableField("\"EQU_DEFINE\"")
    @FieldDisplayDefine(value = "设备品种", typeHandler = "equipCategoryTypeHandler")
    private String equDefine;

    /**
     *
     */
    @TableField("\"PRODUCT_NAME\"")
    @FieldDisplayDefine(value = "产品名称")
    private String productName;

    /**
     *
     */
    @TableField("\"BRAND_NAME\"")
    private String brandName;

    /**
     *
     */
    @TableField("\"EQU_TYPE\"")
    @FieldDisplayDefine(value = "设备型号")
    private String equType;

    /**
     *
     */
    @TableField("\"EQU_PRICE\"")
    @FieldDisplayDefine(value = "设备总价值（万元）")
    private String equPrice;

    /**
     *
     */
    @TableField("\"USE_REGISTRATION_CERTIFICATE\"")
    private String useRegistrationCertificate;

    /**
     *
     */
    @TableField("\"USE_SIGN\"")
    private String useSign;

    /**
     *
     */
    @TableField("\"PRODUCT_PHOTO\"")
    @FieldDisplayDefine(value = "产品照片（可上传产品铭牌）", type = JSON.class)
    private String productPhoto;

    /**
     *
     */
    @TableField("\"CAR_NUMBER\"")
    @FieldDisplayDefine(value = "车牌号")
    private String carNumber;

    /**
     *
     */
    @TableField("\"FRAME_NUMBER\"")
    private String frameNumber;

    /**
     *
     */
    @TableField("\"ENGINE_NUMBER\"")
    private String engineNumber;

    /**
     *
     */
    @TableField("\"MOTOR_NUMBER\"")
    private String motorNumber;

    /**
     *
     */
    @TableField("\"OTHER_ACCESSORIES_REG\"")
    @FieldDisplayDefine(value = "其他附件", type = JSON.class)
    private String otherAccessoriesReg;

    /**
     * 是否车用气瓶（特种气瓶用于区分“内装填料气瓶、纤维缠绕气瓶、低温绝热气瓶”和车用气瓶）
     *  1：是
     *  0：不是
     */
    @TableField("\"WHETHER_VEHICLE_CYLINDER\"")
    private String whetherVehicleCylinder;

    /**
     * 是否撬装式压力容器（压力容器用于区分普通压力容器（安装改造维修单位新增的）和撬装式压力容器（使用单位新增的））
     *  1：是
     *  0：不是
     */
    @TableField("\"WHETHER_SKID_MOUNTED_PRESSURE_VESSEL\"")
    private String whetherSkidMountedPressureVessel;

    /**
     * 最新使用登记证路径
     */

    @TableField("\"LAST_USE_CERT_FILE_PATH\"")
    private String lastUseCertFilePath;

    /**
     * 是否球罐
     *  1：是
     *  0：不是
     */
    @TableField("\"WHETHER_SPHERICAL_TANK\"")
    @FieldDisplayDefine(value = "是否球罐")
    private String whetherSphericalTank;

    /**
     * 气瓶类别(液化石油气瓶、工业气瓶、其他)
     * 0：液化石油气瓶
     * 1：工业气瓶
     * 2：其他
     */
    @TableField("\"CYLINDER_CATEGORY\"")
    @FieldDisplayDefine(value = "气瓶类别")
    private String cylinderCategory;


    /**
     * 检验是否在有限期内：1-有限期内 ；2-不在有效期内【历史无证设备需要】
     */
    @TableField("\"IN_INSPECTION_PERIOD\"")
    private String inInspectionPeriod;

    /**
     * 安装资料是否完整齐全：1-齐全；2-不齐全【历史无证设备需要】
     */
    @TableField("\"INSTALLATION_IS_COMPLETE\"")
    @FieldDisplayDefine(value = "安装资料是否完整齐全", typeHandler = "isCompleteTypeHandler")
    private String installationIsComplete;

    /**
     * 原设备代码-西安数据导入使用
     */
    @TableField("\"ORIGINAL_EQU_CODE\"")
    private String originalEquCode;

    /**
     * 序号-西安数据导入使用
     */
    @TableField("\"XA_SERIAL\"")
    private String xaSerial;

    /**
     * 资料是否齐全（0齐全， 1不齐全）-西安数据导入
     */
    @TableField("\"IS_COMPLETE_XA\"")
    private String isCompleteXa;

    /**
     * 通用标签
     */
    @TableField("\"TAG1\"")
    @FieldDisplayDefine(value = "设备标签", typeHandler = "tagTypeHandler")
    private String tag1;
}
