package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
/**
 * 定时任务表
 *
 * @author duanwei
 * @date 2021-02-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_timed_task")
@ApiModel(value="TaskTimedTask对象", description="定时任务表")
public class TaskTimedTask extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "执行时间")
    private Date executeTime;

    @ApiModelProperty(value = "任务id")
    private Long taskId;

    @ApiModelProperty(value = "类型")
    private Integer type;

    @ApiModelProperty(value = "是否执行")
    private boolean executed;
}
