package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.mapper.FirefightersPostMapper;
import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jcs.api.dto.SinStaticDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

/**
 * @author keyong
 * @title: PersonManageController
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2024/8/1 11:40
 */
@RestController
@Api(tags = "消防队员Api")
@RequestMapping(value = "/center/person")
public class PersonManageController extends BaseController {

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    FirefightersPostMapper firefightersPostMapper;

    @Autowired
    IOrgUsrService orgUsrService;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/fire/info")
    @ApiOperation(value = "获取消防员取证信息")
    public ResponseModel getFirePersonJobInfo(@RequestParam(value = "bizOrgCode" , required = false)String bizOrgCode) {
        ReginParams reginParam = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (StringUtils.isEmpty(bizOrgCode)) {
            if(null != reginParam) {
                bizOrgCode = reginParam.getPersonIdentity().getCompanyBizOrgCode();
            } else {
                return CommonResponseUtil.success(null);
            }
        }
        return ResponseHelper.buildResponse(firefightersPostMapper.getFirePersonJobInfo(bizOrgCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/yunwei/info")
    @ApiOperation(value = "获取运维人员取证信息")
    public ResponseModel getYWPersonJobInfo(@RequestParam(value = "bizOrgCode" , required = false)String bizOrgCode) {
        ReginParams reginParam = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (StringUtils.isEmpty(bizOrgCode)) {
            if(null != reginParam) {
                bizOrgCode = reginParam.getPersonIdentity().getCompanyBizOrgCode();
            } else {
                return CommonResponseUtil.success(null);
            }
        }
        return ResponseHelper.buildResponse(firefightersPostMapper.getYWPersonJobInfo(bizOrgCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/station/fire")
    @ApiOperation(value = "获取消防员信息")
    public ResponseModel getZZPersonInfo(@RequestParam(value = "bizOrgCode" , required = false)String bizOrgCode) {
        ReginParams reginParam = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (StringUtils.isEmpty(bizOrgCode)) {
            if(null != reginParam) {
                bizOrgCode = reginParam.getPersonIdentity().getCompanyBizOrgCode();
            } else {
                return CommonResponseUtil.success(null);
            }
        }
        return ResponseHelper.buildResponse(firefightersPostMapper.getZZPersonInfo(bizOrgCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/station/yunwei")
    @ApiOperation(value = "获取运维人员信息")
    public ResponseModel getYWPersonInfo(@RequestParam(value = "bizOrgCode" , required = false)String bizOrgCode) {
        ReginParams reginParam = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (StringUtils.isEmpty(bizOrgCode)) {
            if(null != reginParam) {
                bizOrgCode = reginParam.getPersonIdentity().getCompanyBizOrgCode();
            } else {
                return CommonResponseUtil.success(null);
            }
        }
        return ResponseHelper.buildResponse(firefightersPostMapper.getYWPersonInfo(bizOrgCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/station/page", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取站端人员信息", notes = "获取站端人员信息")
    public ResponseModel getStationPersonPage(@RequestParam(value = "pageNumber") int pageNumber,
                                       @RequestParam(value = "pageSize") int pageSize, @RequestParam(required = false) String bizOrgCode,
                                       @RequestParam(required = false) String type) {
        Page<Map<String, Object>> page = new Page<>();
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        return CommonResponseUtil.success(orgUsrService.queryPersonPage(page, bizOrgCode, type));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取中心人员信息", notes = "获取中心人员信息")
    public ResponseModel getCenterPersonInfoPage(@RequestParam(value = "pageNumber") int pageNumber,
                                       @RequestParam(value = "pageSize") int pageSize, @RequestParam(required = false) String bizOrgCode,
                                       @RequestParam(required = false) String stationType) {
        Page<Map<String, Object>> page = new Page<>();
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        return CommonResponseUtil.success(orgUsrService.getCenterPersonInfoPage(page, bizOrgCode, stationType));
    }
}
