package com.yeejoin.amos.knowledgebase.controller;

import com.yeejoin.amos.knowledgebase.face.enumeration.DynamicsFunctional;
import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDynamicsOptionModel;
import com.yeejoin.amos.knowledgebase.face.service.DynamicsOptionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * <p>
 * 知识库系统动态选项配置，多用于动态字段配置 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */

@RestController
@TycloudResource(module = "knowledgebase", value = "dynamicsoption")
@RequestMapping(value = "/v1/dynamicsoption")
@Api(tags = "knowledgebase-动态选项配置")
public class DynamicsOptionResource {

    private final Logger logger = LogManager.getLogger(DynamicsOptionResource.class);
    @Autowired
    private DynamicsOptionService dynamicsOptionService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "创建动态配置字段")
    @RequestMapping(value = "", method = RequestMethod.POST)
    public ResponseModel<KnowledgeDynamicsOptionModel> createOption(@RequestBody KnowledgeDynamicsOptionModel model) {
        if (ValidationUtil.isEmpty(model)
                || ValidationUtil.isEmpty(model.getFieldLabel())
                || ValidationUtil.isEmpty(model.getDataType())
                || ValidationUtil.isEmpty(model.getGroupSeq())
                || ValidationUtil.isEmpty(model.getFieldName()))
            throw new BadRequest("参数校验失败.");
        return ResponseHelper.buildResponse(dynamicsOptionService.createOption(model));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "更新动态配置字段")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.PUT)
    public ResponseModel<KnowledgeDynamicsOptionModel> udpateOption(
            @RequestBody KnowledgeDynamicsOptionModel model,
            @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(dynamicsOptionService.udpateOption(model));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询单个字段信息")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.GET)
    public ResponseModel<KnowledgeDynamicsOptionModel> seleteOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(dynamicsOptionService.queryBySeq(sequenceNbr));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "删除单个字段定义")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.DELETE)
    public ResponseModel<Boolean> deleteOption(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(dynamicsOptionService.deleteOption(sequenceNbr));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据分组查询动态字段列表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseModel<List<KnowledgeDynamicsOptionModel>> queryByGroup(@RequestParam("groupSeq") Long groupSeq) {
        return ResponseHelper.buildResponse(dynamicsOptionService.queryByGroupSeq(groupSeq));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "文档基础信息动态字段查询")
    @RequestMapping(value = "/functional/list", method = RequestMethod.GET)
    public ResponseModel<List<KnowledgeDynamicsOptionModel>> queryByFunctional() {
        return ResponseHelper.buildResponse(dynamicsOptionService.queryByFunctional(RequestContext.getAppKey(), DynamicsFunctional.DOC_BASEINFO.name()));
    }


}
