package com.yeejoin.amos.supervision.business.dao.repository;

import com.yeejoin.amos.supervision.dao.entity.PointClassify;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("iPointClassifyDao")
public interface IPointClassifyDao extends BaseDao<PointClassify, Long> {

	@Modifying
	@Transactional
	@Query(value = "select * from p_point_classify where point_id = ?1", nativeQuery = true)
	List<PointClassify> getPointClassifyByPointId(long id);

	@Modifying
	@Transactional
	@Query(value = "select * from p_point_classify where name = ?1", nativeQuery = true)
	List<PointClassify> getPointClassifyByName(String classifyName);

	@Modifying
	@Transactional
	@Query(value = "delete from p_point_classify where point_id in (?1)", nativeQuery = true)
	void deleteByPointId(List<Long> pointIds);

	PointClassify findByOriginalId(String originalId);
}
