package com.yeejoin.amos.kgd.config;

import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamCacher {
    private static final Logger log = LoggerFactory.getLogger(InputStreamCacher.class);

    /**
     * 将InputStream中的字节保存到ByteArrayOutputStream中
     */
    private ByteArrayOutputStream byteArrayOutputStream;
    private InputStream inputStream;

    public InputStreamCacher(InputStream inputStream){
        if(inputStream == null){
            return;
        }

        this.inputStream = inputStream;
        initCache();
    }

    /**
     * 初始化
     */
    private void initCache(){
        byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len;
        try{
            while ((len = inputStream.read(buffer)) >-1 ){
                byteArrayOutputStream.write(buffer, 0 , len);
            }
            byteArrayOutputStream.flush();
        }catch (IOException e){
            log.error(e.getMessage(), e);
        }
    }

    /**
     * 获取缓存流
     * @return InputStream
     */
    public InputStream getInputStream(){
        if(byteArrayOutputStream == null){
            return this.inputStream;
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    /**
     * 销毁
     */
    public void destroyCache(){
        this.byteArrayOutputStream = null;
        if(this.inputStream != null){
            try {
                this.inputStream.close();
            }catch (IOException e){
                e.printStackTrace();
            }
        }
    }
}
