package com.yeejoin.equipmanage.controller;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.service.ISearchService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "搜索Api")
@RequestMapping(value = "/search", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class SearchController {

	@Autowired
	private ISearchService iSearchService;

	/**
	 * 万能搜(按仓库)
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/universal", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public IPage<Map<String, String>> universal(HttpServletRequest request, Long warehouseId, String keyword,
			String pageNum, String pageSize) {
		Page<Map<String, String>> pageBean;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		return iSearchService.universal(warehouseId, keyword, pageBean);
	}

}
