package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.dto.OrgMenuDto;
import com.yeejoin.equipmanage.common.dto.AreaDto;
import com.yeejoin.equipmanage.common.entity.Area;
import com.yeejoin.equipmanage.common.vo.AreaResquest;
import com.yeejoin.equipmanage.common.vo.AreaTreeVo;
import com.yeejoin.equipmanage.common.vo.UnitAreaTreeVo;

import java.util.List;
import java.util.Map;

/**
 * 区域 服务类
 *
 * @author duanwei
 * @date 2021-04-27
 */
public interface IAreaService extends IService<Area> {
    /**
     * 获取区域树
     * @return
     */
    List<UnitAreaTreeVo> getAreaTreeVoByBizOrgCode(String bizOrgCode);

    List<UnitAreaTreeVo> getAreaTreeVoById(long id, String bizOrgCode);

    /**
     * 根据条件分页
     * @param page
     * @param area
     * @return
     */
    IPage<AreaResquest> areaList(Page page, Area area);

    /**
     * 根据bizOrgCode获取单位区域树
     * @return list
     */
    List<UnitAreaTreeVo> getAreaTreeListVo();


    /**
     * 根据登录人公司树
     * @return List<OrgMenuDto>
     */
    List<OrgMenuDto> companyDeptTree();

    Object saveArea(AreaResquest areaResquest);

    Object updateArea(AreaResquest areaResquest);

    int deleteArea(Long instanceId);

    Map<String,Object> getById(Long instanceId);

    /**
     * 获取指定层级区域树，起步2级树
     * @param tier
     * @return
     */
    List<AreaDto> getAreaTierTree(Integer tier);
}
