package com.yeejoin.amos.patrol.common.remote;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.yeejoin.amos.patrol.business.constants.XJConstant;
import com.yeejoin.amos.patrol.business.util.HttpUtil;
import com.yeejoin.amos.patrol.common.enums.RiskFactorWorkFlowActionTypeEnum;
import com.yeejoin.amos.patrol.common.enums.WorkFlowRiskFactorUriEnum;
import com.yeejoin.amos.patrol.core.common.request.CheckResultPushSpcRequest;
import com.yeejoin.amos.patrol.core.common.request.LatentDangerResultPushSpcRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Map;

@Service("remoteSpcService")
public class RemoteSpcService {

    private final Logger logger = LoggerFactory.getLogger(RemoteSpcService.class);

    @Value("${params.spc.address}")
    private String address;

    private static final String success = "SUCCESS";

    private String buildUrl(String address, WorkFlowRiskFactorUriEnum workFlowRiskFactorUriEnum, Map<String, String> map) {
        String uri = workFlowRiskFactorUriEnum.getUri();
        String params = workFlowRiskFactorUriEnum.getParams();
        if (!StringUtils.isEmpty(params) && map != null) {
            String[] paramsArr = params.split(",");
            for (String param : paramsArr) {
                uri = uri.replace("{" + param + "}", map.get(param));
            }
        }
        return address + uri;
    }

    private JSONObject handleResult(String resultStr) {
        if (resultStr == null) {
            return null;
        }
        JSONObject json = JSON.parseObject(resultStr);
        if (success.equals(json.getString("result"))) {
            return json;
        }
        return null;
    }

    public JSONObject wakeUpOrRestartRiskFactorFlow(String instanceId, WorkFlowRiskFactorUriEnum factorUriEnum, String token, RiskFactorWorkFlowActionTypeEnum actionType) {
        String url = buildUrl(address, factorUriEnum, null);
        JSONObject body = new JSONObject();
        body.put("instanceId", instanceId);
        body.put("actionType", actionType.getActionType());
        Map<String, String> headerMap = Maps.newHashMap();
        headerMap.put(XJConstant.TOKEN_KEY, token);
        String resultStr = HttpUtil.sendHttpPostJsonWithHeader(url, body.toJSONString(), headerMap);
        return handleResult(resultStr);
    }

    public JSONObject pushSpcCheckResult(CheckResultPushSpcRequest checkResultPushSpcRequest) {
        String url = buildUrl(address, WorkFlowRiskFactorUriEnum.检查结果推送, null);
        String stringJson = JSONObject.toJSONString(checkResultPushSpcRequest);
        String resultStr = HttpUtil.sendHttpPostJson(url, stringJson);
        return handleResult(resultStr);
    }

    public JSONObject pushLatentDangerExcuteResult(LatentDangerResultPushSpcRequest latentDangerResultPushSpcRequest) {
        String url = buildUrl(address, WorkFlowRiskFactorUriEnum.隐患治理结果推送, null);
        String stringJson = JSONObject.toJSONString(latentDangerResultPushSpcRequest);
        String resultStr = HttpUtil.sendHttpPostJson(url, stringJson);
        logger.info("\r\n请求路径=======================>" + url + "\r\n请求参数=======================>" + stringJson + "\r\n返回参数=======================>" + resultStr);
        return handleResult(resultStr);
    }
    
    
    public JSONObject queryPagetree() {
        String url = buildUrl(address, WorkFlowRiskFactorUriEnum.等级查询, null);
        String resultStr = HttpUtil.sendHttpPostJson(url, null);
        return handleResult(resultStr);
    }

}
