package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.TemporaryDataMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
@EnableScheduling
@Slf4j
public class AnalysisFanStationImpl {


    @Autowired
    private TemporaryDataMapper temporaryDataMapper;

    public Map<String,Object> getStationWindSpeedStatistics(String gatewayId, String equipmentIndexName){
        List<Map<String, String>> list = temporaryDataMapper.getStationWindSpeedStatistics(gatewayId, equipmentIndexName);
        Map<String,Object> map = new HashMap<>();
        List<String> valueList = new ArrayList<>();
        Set<String> time = new  TreeSet<>();
        for (Map<String, String> stringStringMap : list) {
            valueList.add(stringStringMap.get("value"));
            time.add(stringStringMap.get("createdTime"));
        }
        map.put("seriesData", valueList);
        map.put("axisData",time);
        return map;
    }
}
