package com.yeejoin.amos.boot.module.ugp.biz.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.ugp.api.Enum.OrgEnum;
import com.yeejoin.amos.boot.module.ugp.api.entity.Company;
import com.yeejoin.amos.boot.module.ugp.api.entity.SuperviseRule;
import com.yeejoin.amos.boot.module.ugp.api.mapper.CompanyMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.SuperviseRuleMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IUnitPersonService;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


@Service
public class UnitPersonServiceImpl implements IUnitPersonService {

    @Autowired
    OrgServiceImpl orgService;

    @Autowired
    CompanyMapper companyMapper;

    @Autowired
    SuperviseRuleMapper superviseRuleMapper;

    @BusinessIdentify
    public String selectUnit() {
        Long companySequenceNbr = orgService.getReginParams().getBusinessInfo().getCompanySequenceNbr();
        Company companyInformation = companyMapper.selectById(companySequenceNbr);
        String companyKey = companyInformation.getType();
        String regionCode = companyInformation.getRegionCode();
        String unitName = "";
        String unitForName = "";
        if (companyKey.equals(OrgEnum.安装单位.getKey()) || companyKey.equals(OrgEnum.设计单位.getKey()) || companyKey.equals(OrgEnum.建设单位.getKey())) {
            LambdaQueryWrapper<Company> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(Company::getRegionCode, regionCode);
            List<Company> codeLists = companyMapper.selectList(wrapper);
            for (Company codeList : codeLists) {
                LambdaQueryWrapper<SuperviseRule> wrapper1 = new LambdaQueryWrapper<>();
                wrapper1.eq(SuperviseRule::getAdminRegionCode, codeList.getRegionCode());
                List<SuperviseRule> superviseRuleLists = superviseRuleMapper.selectList(wrapper1);
                for (SuperviseRule superviseRuleList : superviseRuleLists) {
                    LambdaQueryWrapper<Company> wrapper2 = new LambdaQueryWrapper<>();
                    wrapper2.eq(Company::getSequenceNbr, superviseRuleList.getSuperviseDeptId());
                    List<Company> companyNames = companyMapper.selectList(wrapper2);
                    for (Company companyName : companyNames) {
                        unitName = companyName.getName();
                    }
                }
            }
        } else if (companyKey.equals(OrgEnum.监察部门.getKey())) {
            LambdaQueryWrapper<SuperviseRule> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SuperviseRule::getSuperviseDeptId, companySequenceNbr);
            List<SuperviseRule> adminRegions = superviseRuleMapper.selectList(wrapper);
            for (SuperviseRule adminRegion : adminRegions) {
//                unitName = String.join("、", String.valueOf(adminRegion.getAdminRegion()));
                if (!ValidationUtil.isEmpty(adminRegion.getAdminRegion())) {

                    if(unitName.equals("")){
                        unitName = unitName.concat(adminRegion.getAdminRegion());
                    }else {
                        unitName = unitName.concat("、"+adminRegion.getAdminRegion());
                    }

                }
            }


        } else if (companyKey.equals(OrgEnum.监检机构.getKey())) {
            LambdaQueryWrapper<SuperviseRule> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SuperviseRule::getInspectionUnitId, companySequenceNbr);
            List<SuperviseRule> adminRegions = superviseRuleMapper.selectList(wrapper);
            for (SuperviseRule adminRegion : adminRegions) {
                if (!ValidationUtil.isEmpty(adminRegion.getAdminRegion())) {

                    if(unitName.equals("")){
                        unitName = unitName.concat(adminRegion.getAdminRegion());
                    }else {
                        unitName = unitName.concat("、"+adminRegion.getAdminRegion());
                    }

                }
            }
        }
        Set<String> hashSet = new HashSet<>();
        for (String unName :  unitName.split("、")){
            hashSet.add(unName);
        }
        for (String iName : hashSet){
            if(unitForName.equals("")){
                unitForName = unitForName+iName;
            }else {
                unitForName = unitForName.concat("、")+iName;
            }
        }

        return unitForName;
    }


}
