package com.yeejoin.amos.boot.module.cylinder.flc.api.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * 气瓶充装信息--充装前检查
 *
 * @author duanwei
 * @date 2022-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class CylinderFillingBaseEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "气瓶唯一标识码，制造单位统一信用代码-出厂编号")
    private String sequenceCode;

    @ApiModelProperty(value = "气瓶类型")
    private String cylinderType;

    @ApiModelProperty(value = "充装前检查Id")
    private String fillingBeforeId;

    @ApiModelProperty(value = "作业人员证书编号")
    private String inspectorUserNum;

    @ApiModelProperty(value = "作业人员姓名")
    private String inspectorUser;

    @ApiModelProperty(value = "充装企业名称")
    private String fillingUnitName;

    @ApiModelProperty(value = "同步时间 yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "0-新增 1-更新 2-删除")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

    @ApiModelProperty(value = "数据完整度")
    private Double integrity;

    @ApiModelProperty(value = "充装企业统一社会信用代码")
    private String fillingUnitCreditCode;

    @ApiModelProperty(value = "对接接口版本")
    private String version = "v1";

    @ApiModelProperty(value = "更新人员")
    private String recUserName;

    @ApiModelProperty(value = "是否删除")
    private boolean isDelete;
}
