package com.yeejoin.amos.boot.module.jczs.biz.utils;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.feign.AmosFeignService;
import com.yeejoin.amos.boot.module.jczs.api.dto.ElevatorDto;
import com.yeejoin.amos.boot.module.jczs.api.dto.MaintenanceUnitDto;
import com.yeejoin.amos.boot.module.jczs.api.entity.Elevator;
import com.yeejoin.amos.boot.module.jczs.api.entity.MaintenanceUnit;
import com.yeejoin.amos.boot.module.jczs.flc.api.dto.CylinderInfoDto;
import com.yeejoin.amos.boot.module.jczs.flc.api.dto.EquipmentDto;
import com.yeejoin.amos.boot.module.jczs.flc.api.dto.EquipmentInformDto;
import com.yeejoin.amos.boot.module.jczs.flc.api.dto.UnitInfoDto;
import com.yeejoin.amos.boot.module.jczs.flc.api.entity.CylinderInfo;
import com.yeejoin.amos.boot.module.jczs.flc.api.entity.CylinderUnit;
import com.yeejoin.amos.boot.module.jczs.flc.api.entity.Equipment;
import com.yeejoin.amos.boot.module.jczs.flc.api.entity.EquipmentInform;
import com.yeejoin.amos.boot.module.jczs.flc.api.entity.UnitInfo;
import com.yeejoin.amos.boot.module.jczs.flc.api.enums.EquipmentStatusEnum;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.stream.Collectors;


/**
 * @title: 实体类 Dto，Vo，entity 转换工具类
 * @Author fpy
 * @Date: 2021/6/3 13:53
 */
@Component
public class BeanDtoVoUtils {

    @Autowired
    private AmosFeignService amosFeignService;

    private static BeanDtoVoUtils beanDtoVoUtils;

    private static List<DictionarieValueModel> elevatorCategory;
    private static List<DictionarieValueModel> elevatorUseSiteCategory;
    private static List<DictionarieValueModel> elevatorMaintainType;
    private static List<DictionarieValueModel> elevatorMaintainPeriod;
    private static List<DictionarieValueModel> elevatorDragMode;
    private static List<DictionarieValueModel> qualificationLevel;


    @PostConstruct
    public void init() {
        beanDtoVoUtils = this;
        beanDtoVoUtils.amosFeignService = this.amosFeignService;
    }

    /**
     * 获取电梯信息中数据字典的值
     *
     * @throws Exception 获取字典值错误
     */
    public static void getElevatorDictionaryByDictCode() throws Exception {
        elevatorCategory = beanDtoVoUtils.amosFeignService.listDictionaryByDictCode("ELEVATOR_CATEGORY");
        elevatorUseSiteCategory = beanDtoVoUtils.amosFeignService.listDictionaryByDictCode(
                "ELEVATOR_USE_SITE_CATEGORY");
        elevatorMaintainType = beanDtoVoUtils.amosFeignService.listDictionaryByDictCode("ELEVATOR_MAINTAIN_TYPE");
        elevatorMaintainPeriod = beanDtoVoUtils.amosFeignService.listDictionaryByDictCode("ELEVATOR_MAINTAIN_PERIOD");
        elevatorDragMode = beanDtoVoUtils.amosFeignService.listDictionaryByDictCode("ELEVATOR_DRAG_MODE");
    }

    /**
     * 获取维保单位中数据字典的值
     *
     * @throws Exception 获取字典值错误
     */
    public static void getMaintenanceUnitDictionaryByDictCode() throws Exception {
        qualificationLevel = beanDtoVoUtils.amosFeignService.listDictionaryByDictCode(
                "MAINTENANCE_UNIT_QUALIFICATION_LEVEL");
    }


    /**
     * Dot ,Vo ,Entity 相互转换
     *
     * @param source      原数据
     * @param targetClass 目标类
     * @param <T>         泛型类
     * @return 转换返回值
     */
    public static <T> T convert(Object source, Class<T> targetClass) {
        // 判断source是否为空
        if (source == null) {
            return null;
        }
        // 判断targetClass是否为空
        if (targetClass == null) {
            return null;
        }
        try {
            // 创建新的对象实例
            T target = targetClass.newInstance();
            // 把原对象数据拷贝到新对象
            BeanUtils.copyProperties(source, target);
            // 返回新对象
            return target;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * IPage<Entity> 分页对象转 IPage<Vo>
     *
     * @param page 原分页对象
     * @param v    目标vo类
     * @param <E>  泛型类
     * @param <V>  泛型类
     * @return 转换后的分页对象
     */
    public static <E, V> IPage<V> iPageVoStream(IPage<E> page, Class<V> v) {
        return page.convert(item -> {
            try {
                return convert(item, v);
            } catch (Exception e) {
                return null;
            }
        });
    }

    /**
     * 将电梯实体类转换为Dto
     *
     * @param source  实体类
     * @param isBatch 是否批量
     * @return Vo类
     */
    public static ElevatorDto convertElevatorToDto(Elevator source, boolean isBatch) {
        // 判断source是否为空
        if (source == null) {
            return null;
        }
        try {
            // 创建新的对象实例
            ElevatorDto target = new ElevatorDto();
            // 把原对象数据拷贝到新对象
            BeanUtils.copyProperties(source, target);
            if (!isBatch) {
                getElevatorDictionaryByDictCode();
            }
            List<DictionarieValueModel> categoryValue =
                    elevatorCategory.stream().filter(e -> e.getDictDataKey().equals(source.getCategory())).collect(Collectors.toList());
            target.setCategory(categoryValue.isEmpty() ? "" : categoryValue.get(0).getDictDataValue());
            List<DictionarieValueModel> useSiteCategoryValue =
                    elevatorUseSiteCategory.stream().filter(e -> e.getDictDataKey().equals(source.getUseSiteCategory())).collect(Collectors.toList());
            target.setUseSiteCategory(useSiteCategoryValue.isEmpty() ? "" :
                    useSiteCategoryValue.get(0).getDictDataValue());
            List<DictionarieValueModel> maintainTypeValue =
                    elevatorMaintainType.stream().filter(e -> e.getDictDataKey().equals(source.getMaintainType())).collect(Collectors.toList());
            target.setMaintainType(maintainTypeValue.isEmpty() ? "" : maintainTypeValue.get(0).getDictDataValue());
            List<DictionarieValueModel> maintainPeriodValue =
                    elevatorMaintainPeriod.stream().filter(e -> e.getDictDataKey().equals(source.getMaintainPeriod())).collect(Collectors.toList());
            target.setMaintainPeriod(maintainPeriodValue.isEmpty() ? "" :
                    maintainPeriodValue.get(0).getDictDataValue());
            List<DictionarieValueModel> dragModeValue =
                    elevatorDragMode.stream().filter(e -> e.getDictDataKey().equals(source.getDragMode())).collect(Collectors.toList());
            target.setDragMode(dragModeValue.isEmpty() ? "" : dragModeValue.get(0).getDictDataValue());
            // 返回新对象
            return target;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 将Elevator转换为IPage<ElevatorDto>
     *
     * @param page 原分页对象
     * @return 转换后的Vo
     */
    public static IPage<ElevatorDto> elevatorIPageDto(IPage<Elevator> page) {
        try {
            getElevatorDictionaryByDictCode();
        } catch (Exception e) {
            return null;
        }
        return page.convert(item -> {
            try {
                return convertElevatorToDto(item, true);
            } catch (Exception e) {
                return null;
            }
        });
    }



    /**
     * 将MaintenanceUnit转换为Vo
     *
     * @param source  源对象
     * @param isBatch 是否批量
     * @return 转换后的Vo
     */
    public static MaintenanceUnitDto convertMaintenanceUnitToVo(MaintenanceUnit source, boolean isBatch) {
        // 判断source是否为空
        if (source == null) {
            return null;
        }
        try {
            // 创建新的对象实例
            MaintenanceUnitDto target = new MaintenanceUnitDto();
            // 把原对象数据拷贝到新对象
            BeanUtils.copyProperties(source, target);
            target.setDistrict(target.getCity() + target.getDistrict());
            // 返回新对象
            // 根据数据字典设置值
            if (!isBatch) {
                getMaintenanceUnitDictionaryByDictCode();
            }
            List<DictionarieValueModel> qualificationLevelValue =
                    qualificationLevel.stream().filter(e -> e.getDictDataKey().equals(source.getQualificationLevel())).collect(Collectors.toList());
            target.setQualificationLevel(qualificationLevelValue.isEmpty() ? "" :
                    qualificationLevelValue.get(0).getDictDataDesc());
            return target;
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 将MaintenanceUnit转换为IPage<MaintenanceUnitVo>
     *
     * @param page 原分页对象
     * @return 转换后的分页对象
     */
    public static IPage<MaintenanceUnitDto> maintenanceUnitIPageDto(IPage<MaintenanceUnit> page) {
        try {
            getMaintenanceUnitDictionaryByDictCode();
        } catch (Exception e) {
            return null;
        }
        return page.convert(item -> {
            try {
                return convertMaintenanceUnitToVo(item, true);
            } catch (Exception e) {
                return null;
            }
        });
    }

    /**
     * 将企业注册实体类转换为Vo
     *
     * @param page 原分页对象
     * @return 转换后的分页对象
     */
    public static IPage<UnitInfoDto> unitInfoIPageDto(IPage<UnitInfo> page) {

        return page.convert(item -> {
            try {
                UnitInfoDto target = new UnitInfoDto();
                // 把原对象数据拷贝到新对象
                BeanUtils.copyProperties(item, target);
                if(item.getIsChange()) {
                    target.setTypeStr("变更");
                } else {
                    target.setTypeStr("注册");
                }
                if(0 == item.getUnitStatus()) {
                    target.setStatusStr("审批中");
                } else if(1 == item.getUnitStatus()) {
                    target.setStatusStr("审批结束");
                } else if(2 == item.getUnitStatus()) {
                    target.setStatusStr("已驳回");
                }
                StringBuffer sb = new StringBuffer();
                sb.append(StringUtils.isNotBlank(item.getProvince()) ? item.getProvince() : "");
                sb.append(StringUtils.isNotBlank(item.getCity()) ? item.getCity() : "");
                sb.append(StringUtils.isNotBlank(item.getDistrict()) ? item.getDistrict() : "");
                sb.append(StringUtils.isNotBlank(item.getStree()) ? item.getStree() : "");
                sb.append(StringUtils.isNotBlank(item.getCommunity()) ? item.getCommunity() : "");
                sb.append(StringUtils.isNotBlank(item.getAddress()) ? item.getAddress() : "");
                target.setFullAddress(sb.toString());
                target.setAdminLoginPwd(null);
                return target;
            } catch (Exception e) {
                return null;
            }
        });
    }

    /**
     * 将设备实体类转换为Vo
     *
     * @param page 原分页对象
     * @return 转换后的分页对象
     */
    public static IPage<EquipmentDto> equipmentIPageDto(IPage<Equipment> page) {

        return page.convert(item -> {
            try {
                EquipmentDto target = new EquipmentDto();
                // 把原对象数据拷贝到新对象
                BeanUtils.copyProperties(item, target);
                if(EquipmentStatusEnum.未安装.getCode().equals(item.getStatus())) {
                    target.setStatus(EquipmentStatusEnum.未安装.getName());
                } else  if(EquipmentStatusEnum.已安装.getCode().equals(item.getStatus())) {
                    target.setStatus(EquipmentStatusEnum.已安装.getName());
                }
                return target;
            } catch (Exception e) {
                return null;
            }
        });
    }

    public static IPage<CylinderInfoDto> cyinderInfoIPageDto(IPage<CylinderInfo> page) {

        return page.convert(item -> {
            try {
                CylinderInfoDto target = new CylinderInfoDto();
                // 把原对象数据拷贝到新对象
                BeanUtils.copyProperties(item, target);
//                if(0 == item.getCylinderStatus()) {
//                    target.setCylinderStatusStr("在用");
//                } else if(1 == item.getCylinderStatus()) {
//                    target.setCylinderStatusStr("停用");
//                } else if(2 == item.getCylinderStatus()) {
//                    target.setCylinderStatusStr("注销");
//                } else if(3 == item.getCylinderStatus()) {
//                    target.setCylinderStatusStr("报废");
//                } else {
//                    target.setCylinderStatusStr("");
//                }

//                if(1 == item.getCylinderVariety()) {
//                    target.setCylinderVarietyStr("无缝气瓶");
//                } else if(2 == item.getCylinderVariety()) {
//                    target.setCylinderVarietyStr("焊接气瓶");
//                } else if(3 == item.getCylinderVariety()) {
//                    target.setCylinderVarietyStr("缠绕气瓶");
//                } else if(4 == item.getCylinderVariety()) {
//                    target.setCylinderVarietyStr("绝热气瓶");
//                } else if(5 ==item.getCylinderVariety()) {
//                    target.setCylinderVarietyStr("内装填料气瓶");
//                } else {
//                    target.setCylinderVarietyStr("");
//                }
                return target;
            } catch (Exception e) {
                return null;
            }
        });
    }





}