package com.yeejoin.amos.boot.biz.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
* 数据字典
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_data_dictionary")
@ApiModel(value="DataDictionary对象", description="数据字典")
public class DataDictionary extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "code")
    private String code;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "父级")
    private Long parent;

    //新加排序字段
    @ApiModelProperty(value = "排序字段")
    private int sortNum;
    
    @ApiModelProperty(value = "对应消防专家的数量，仅适应与消防资源专家领域树结构的展示")
    @TableField(exist = false)
    private int count;

}
