package com.yeejoin.amos.boot.biz.common.service.impl;


import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.dao.mapper.DataDictionaryMapper;
import com.yeejoin.amos.boot.biz.common.dto.DataDictionaryDto;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.IDataDictionaryService;
import com.yeejoin.amos.boot.biz.common.utils.Menu;
import com.yeejoin.amos.boot.biz.common.utils.MenuFrom;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.biz.common.utils.TreeParser;

/**
 * 数据字典 服务实现类
 *
 * @author tb
 * @date 2021-06-07
 */
@Service
public class DataDictionaryServiceImpl extends BaseService<DataDictionaryDto, DataDictionary, DataDictionaryMapper> implements IDataDictionaryService {
    @Autowired
    RedisUtils redisUtils;

    @Value("${redis.cache.failure.time}")
    private long time;
    @Autowired
    DataDictionaryMapper dataDictionaryMapper;

    @Override
    public Object getFireChemical(String type) throws Exception {
        QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type", type);
        queryWrapper.orderByAsc("sort_num");

        if (redisUtils.hasKey(RedisKey.DATA_DICTIONARY_CODE + type)) {
            Object obj = redisUtils.get(RedisKey.DATA_DICTIONARY_CODE + type);
            return obj;
        } else {
            Collection<DataDictionary> list = this.list(queryWrapper);
            List<MenuFrom> menus = TreeParser.getTreexin(null, list, DataDictionary.class.getName(), "getCode", 0,
                    "getName", "getParent", null);
            MenuFrom Me = new MenuFrom("-1", "-1", "-1", "危化品库", "危化品库", "危化品库", "-1", null);
            Me.setIsLeaf(false);
            Me.setChildren(menus);
            redisUtils.set(RedisKey.DATA_DICTIONARY_CODE + type, JSON.toJSON(Me), time);
            return Me;
        }
    }

    @Override
    public Object gwmcDataDictionary(String type) throws Exception {
        QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type", type);
        queryWrapper.orderByAsc("sort_num");

        if (redisUtils.hasKey(RedisKey.DATA_DICTIONARY_CODE + type)) {
            Object obj = redisUtils.get(RedisKey.DATA_DICTIONARY_CODE + type);
            return obj;
        } else {
            Collection<DataDictionary> list = this.list(queryWrapper);
            List<Menu> menus = TreeParser.getTree(null, list, DataDictionary.class.getName(), "getCode", 0, "getName"
                    , "getParent", null);
            redisUtils.set(RedisKey.DATA_DICTIONARY_CODE + type, JSON.toJSON(menus), time);
            return menus;
        }
    }

    public List<MenuFrom> getGWMCDataDictionary(String type) throws Exception {
        QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type", type);
        queryWrapper.orderByAsc("sort_num");

        Collection<DataDictionary> list = this.list(queryWrapper);
        List<MenuFrom> menus = TreeParser.getTreexin(null, list, DataDictionary.class.getName(), "getCode", 0, "getName"
                , "getParent", null);
        return menus;

    }
    
    
    public List<DataDictionary> getDataDictionaryAndCount(){
    	List<DataDictionary> list=	dataDictionaryMapper.getDataDictionaryListAndCount();
		return list;
    	
    }
}
