package com.yeejoin.amos.boot.module.jcs.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author DELL
 */
@Getter
@AllArgsConstructor
public enum FireCarStatusEnum {
    // 执勤状态
    执勤("ZW", "1", "执勤"),
    // 出动状态
    出动("ZQ", "2", "出动"),
    // 维修状态
    维修("WX","3", "维修"),
    // 退役状态
    退役("TY","6", "退役"),
    // 报废状态
    报废("BF","7", "报废");

    private String key;
    private String code;
    private String name;

    public static FireCarStatusEnum getEnum(String code) {
        for (FireCarStatusEnum status : FireCarStatusEnum.values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }
}
