package com.yeejoin.amos.supervision.mqtt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.supervision.business.dto.OrgUsrFormDto;
import com.yeejoin.amos.supervision.business.service.intfc.IPointService;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqxListener;

/**
 * @author keyong
 * @title: AmosMqttListener
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/8/20 15:31
 */
@Component
@Slf4j
public class AmosMqttListener extends EmqxListener {

    @Autowired
    private IPointService iPointService;

    @Override
    public void processMessage(String topic, MqttMessage message) {
        String msg = String.valueOf(message);
        if ("jcs/company/topic/add".equals(topic)) {
            OrgUsrFormDto usrFormDto = JSON.parseObject(msg, OrgUsrFormDto.class);
            iPointService.syncSavePoint(usrFormDto);
        } else {
            iPointService.delPointByPointNo(Long.valueOf(msg));
        }
        try {
        } catch (Exception e) {
            log.info("同步机场单位消息失败:{}", e.getMessage());
        }
        log.info("机场单位消息同步完成");
    }

}
