package com.yeejoin.amos.boot.module.jg.biz.context;

import com.yeejoin.amos.boot.module.jg.api.service.IEquipUsedCheck;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @author Administrator
 */
@Component
public class EquipUsedCheckStrategyContext implements ApplicationContextAware {

    private static Map<String, IEquipUsedCheck> iActionExecuteStrategyHashMap = new HashMap<>();


    public static IEquipUsedCheck getUsedStrategy(String bizType) {
        return Optional.ofNullable(iActionExecuteStrategyHashMap.get(bizType)).orElseThrow(() -> new RuntimeException(String.format("not found %s type strategy", bizType)));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, IEquipUsedCheck> strategyBeans = applicationContext.getBeansOfType(IEquipUsedCheck.class);
        if (strategyBeans.isEmpty()) {
            return;
        }
        for (IEquipUsedCheck strategy : strategyBeans.values()) {
            iActionExecuteStrategyHashMap.put(strategy.applyBizType(), strategy);
        }
    }
}
