package com.yeejoin.amos.patrol.business.dto;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 发送到规则平台的消息对象
 */
@Data
@RuleFact(value = "消防巡查", project = "消息规则")
public class MsgRo implements Serializable {

    private static final long serialVersionUID = -4210693601552557441L;

    @Label("名称")
    private String name;

    @Label("内容")
    private String content;

    @Label(value = "推送时间")
    private String sendTime;

    @Label(value = "接收人")
    private List<String> recivers;

    @Label(value = "发送到web标识")
    private Boolean isSendWeb;

    @Label(value = "发送到app标识")
    private Boolean isSendApp;

    @Label("关联id")
    private String relationId;

    @Label("消息类型")
    private String msgType;

    @Label(value = "终端标识")
    private String terminal;

    @Label(value = "扩展参数")
    private Map<String, String> extras;

}
