package com.yeejoin.amos.boot.module.jxiop.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 户用光伏表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="HouseholdPvDto", description="户用光伏表")
public class HouseholdPvDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "户主姓名")
    private String name;

    @ApiModelProperty(value = "户号")
    private String number;

    @ApiModelProperty(value = "厂商")
    private String platformCompanyId;

    @ApiModelProperty(value = "性别")
    private String sex;

    @ApiModelProperty(value = "身份证号")
    private String idNumber;

    @ApiModelProperty(value = "证件过期时间")
    private Date expiryTime;

    @ApiModelProperty(value = "签发机关")
    private String issuingAuthority;

    @ApiModelProperty(value = "户籍地址")
    private String residenceAddress;

    @ApiModelProperty(value = "手机号码")
    private String phone;

    @ApiModelProperty(value = "居住地")
    private String address;

    @ApiModelProperty(value = "邮编")
    private String postcode;

    @ApiModelProperty(value = "身份证正面")
    private String idFrontPhoto;

    @ApiModelProperty(value = "身份证背面")
    private String idBackPhoto;

    @ApiModelProperty(value = "房屋产权证")
    private String housePropertyCertificate;

    @ApiModelProperty(value = "农户首页照片")
    private String homepagePhoto;

    @ApiModelProperty(value = "送达地址")
    private String serviceAddress;

    @ApiModelProperty(value = "组织机构code")
    private String orgCode;

    @ApiModelProperty(value = "告警等级")
    private String level;

    @ApiModelProperty(value = "区域id")
    private Long districtId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

}
