package com.yeejoin.amos.boot.module.jxiop.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 户用光伏合同表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="HouseholdPvLeaseDto", description="户用光伏合同表")
public class HouseholdPvLeaseDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "户用光伏id")
    private Long householdPvId;

    @ApiModelProperty(value = "安装地址")
    private String installAddress;

    @ApiModelProperty(value = "安装日期")
    private Date installDate;

    @ApiModelProperty(value = "预计功率(w)")
    private Integer estimatedPower;

    @ApiModelProperty(value = "组件单片功率(w)")
    private Integer monolithicPower;

    @ApiModelProperty(value = "共计安装数量(块)")
    private Integer installCount;

    @ApiModelProperty(value = "实际容量(w)")
    private Integer actualCapacity;

    @ApiModelProperty(value = "电站类型")
    private String stationType;

    @ApiModelProperty(value = "组件规格")
    private String moduleType;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

}
