package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.HouseholdPvDeviceServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.HouseholdPvDeviceDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 户用光伏设备表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@RestController
@Api(tags = "户用光伏设备表Api")
@RequestMapping(value = "/household-pv-device")
public class HouseholdPvDeviceController extends BaseController {

    @Autowired
    HouseholdPvDeviceServiceImpl householdPvDeviceServiceImpl;

    /**
     * 新增户用光伏设备表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏设备表", notes = "新增户用光伏设备表")
	public ResponseModel<HouseholdPvDeviceDto> save(@RequestBody HouseholdPvDeviceDto model) {
	    model = householdPvDeviceServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏设备表", notes = "根据sequenceNbr更新户用光伏设备表")
	public ResponseModel<HouseholdPvDeviceDto> updateBySequenceNbrHouseholdPvDevice(@RequestBody HouseholdPvDeviceDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(householdPvDeviceServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏设备表", notes = "根据sequenceNbr删除户用光伏设备表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(householdPvDeviceServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个户用光伏设备表",  notes = "根据sequenceNbr查询单个户用光伏设备表")
	public ResponseModel<HouseholdPvDeviceDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(householdPvDeviceServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "户用光伏设备表分页查询",  notes = "户用光伏设备表分页查询")
	public ResponseModel<Page<HouseholdPvDeviceDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<HouseholdPvDeviceDto> page = new Page<HouseholdPvDeviceDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(householdPvDeviceServiceImpl.queryForHouseholdPvDevicePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "户用光伏设备表列表全部数据查询",   notes = "户用光伏设备表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<HouseholdPvDeviceDto>> selectForList() {
	    return ResponseHelper.buildResponse(householdPvDeviceServiceImpl.queryForHouseholdPvDeviceList());
	}
}
