package com.yeejoin.precontrol.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.TaskRiskControlDto;
import com.yeejoin.precontrol.common.entity.TaskRiskControl;
import com.yeejoin.precontrol.common.vo.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 风险管控任务表 Mapper 接口
 *
 * @author duanwei
 * @date 2021-01-28
 */
public interface TaskRiskControlMapper extends BaseMapper<TaskRiskControl> {

    /**
     * 根据查询参数查询风险作业计划任务列表
     *
     * @param page
     * @param taskRiskControlDto 查询参数
     * @return
     */
    IPage<TaskRiskControlVo> listByPage(Page page, @Param("taskRiskControlDto") TaskRiskControlDto taskRiskControlDto);

    /**
     * 根据id查询详情
     *
     * @param id
     * @return
     */
    TaskRiskControlVo getDetailById(@Param("id") Long id);

    /**
     * 按照公司查询 去重查询开始日期
     *
     * @param orgCode 公司模糊查询
     * @param level   等级
     * @return List<String>
     */
    List<String> queryBeginDateYear(@Param("orgCode") String orgCode, @Param("level") String level);

    /**
     * 分页查询
     *
     * @param page  分页信息
     * @param param 页面参数
     * @return Page<TaskRiskControlVo>
     */
    Page<TaskRiskControlAppVo> listTaskByYearPage(Page<TaskRiskControlAppVo> page,
                                                  @Param("param") Map<String, Object> param);

    /**
     * 统计查询任务
     *
     * @param param 公司
     * @return Map<String, Object>
     */
    Map<String, Object> statisticsByLevel(Map<String, Object> param);

    /**
     * 根据当前人员id查询当前所关联计划
     *
     * @param page
     * @param personId
     * @param taskRiskControlDto
     * @return
     */
    Page<TaskRiskControlVo> myListByPage(Page<TaskRiskControlVo> page, Long personId,
                                         TaskRiskControlDto taskRiskControlDto,@Param("doIds")List<Long> doIds);

    /**
     * 查询执行任务的人
     *
     * @param taskId
     * @param status
     * @param examSubjectType 3级考试枚举
     * @return
     */
    List<TaskWorkPersonVo> listPersonInTask(@Param("taskId") Long taskId, @Param("status") Integer status,
                                            @Param("examSubjectType") String examSubjectType);

    /**
     * 是否开始
     */
    boolean isStart(Long id);

    /**
     * 根据配置获取数据
     *
     * @param riskWorkSize
     * @return
     */
    List<TaskRiskControlVo> listByConfig(String orgCode, Integer riskWorkSize);

    List<TaskRiskControl> waitDealTaskList();

    Integer myListCount(Long personId);

    TaskRiskControlDetailVo taskRiskDetail(@Param("id") Long id);

    List<TaskWorkPersonVo> riskPersonList(@Param("id") Long id, @Param("type") Long type);

    List<TaskRiskControlDetailVo> riskNeedProcessList(@Param("orgCode") String orgCode, @Param("projectId") Long projectId);

    IPage<Object> riskWorkPageInfo(Page<BadCompanyVo> page, @Param("orgCode") String orgCode,
                                   @Param("status") Integer status, @Param("taskRiskControlVo") TaskRiskControlVo taskRiskControlVo);

    IPage<Object> antiViolationPageInfo(Page<BadCompanyVo> page, @Param("orgCode") String orgCode,
                                        @Param("status") Integer status, @Param("projectId") Long projectId);
}
