package com.yeejoin.amos.boot.module.jg.biz.edit.permission;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.BaseUseRegisterResultData;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class FillingCompanyTypeForCurrentUser extends BaseUseRegisterResultData {

    private final CompanyBo company;

    private static final String COMPANY_TYPE = "companyType";


    public FillingCompanyTypeForCurrentUser(JSONObject data, CompanyBo company) {
        super(data);
        this.company = company;
    }

    @Override
    public JSONObject getData() {
        JSONObject data = super.getData();
        fillingEditPermission(data);
        return data;
    }


    private void fillingEditPermission(JSONObject jsonObject) {
        if (company.getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
            jsonObject.put(COMPANY_TYPE, BaseController.COMPANY_TYPE_COMPANY);
        } else {
            jsonObject.put(COMPANY_TYPE, BaseController.COMPANY_TYPE_SUPERVISION);
        }
    }

}
