package com.yeejoin.equipmanage.quartz;

import com.yeejoin.amos.feign.systemctl.model.MessageModel;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecific;
import com.yeejoin.equipmanage.common.enums.PressurePumpEnum;
import com.yeejoin.equipmanage.common.enums.PressurePumpMessageEnum;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.common.utils.StringUtil;
import com.yeejoin.equipmanage.common.vo.Token;
import com.yeejoin.equipmanage.fegin.SystemctlFeign;
import com.yeejoin.equipmanage.remote.RemoteSecurityService;
import lombok.extern.slf4j.Slf4j;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import java.text.SimpleDateFormat;
import java.util.*;

@Slf4j
public class PumpSendMessage implements Job {

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {

        try {
            Map jobDataMap = (Map) jobExecutionContext.getJobDetail().getJobDataMap().get("parameterList");
            String jobName = String.valueOf(jobDataMap.get("jobName"));
            String triggerName = String.valueOf(jobDataMap.get("triggerName"));
            String triggerGroupName = String.valueOf(jobDataMap.get("triggerGroupName"));
            String jobGroupName = String.valueOf(jobDataMap.get("jobGroupName"));
            EquipmentSpecific equipmentSpecific = (EquipmentSpecific)jobDataMap.get("equipmentSpecific");
            PressurePumpEnum pressurePumpEnum = (PressurePumpEnum)jobDataMap.get("pressurePumpEnum");
            SystemctlFeign systemctlFeign = (SystemctlFeign)jobDataMap.get("systemctlFeign");
            RemoteSecurityService remoteSecurityService = (RemoteSecurityService)jobDataMap.get("remoteSecurityService");

            MessageModel model = new MessageModel();
            model.setSendTime(new Date());
            String body = "";
            Map<String, String> map = new HashMap<>(4);
            String allMessage = PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ_YXSC.getAllMessage();
            if (StringUtil.isNotEmpty(allMessage)) {
                String content = String.format(allMessage, pressurePumpEnum.getRightValue());
                map.put("content", content);
                map.put("type", "漏水提醒");
                map.put("time", new SimpleDateFormat(DateUtils.DATE_TIME_PATTERN).format(new Date()));
                map.put("name", equipmentSpecific.getName());
            }
            String recordMessage = PressurePumpMessageEnum.MESSAGE_LEVEL_QT_WJ_YXSC.getRecordMessage();
            if (StringUtil.isNotEmpty(recordMessage)) {
                body = String.format(recordMessage,new SimpleDateFormat(DateUtils.DATE_TIME_PATTERN).format(new Date()), equipmentSpecific.getName(), equipmentSpecific.getPosition(), pressurePumpEnum.getRightValue());
            }

            model.setBody(body);
            model.setExtras(map);
            model.setMsgType("pressurePump");
            model.setIsSendApp(false);
            model.setTerminal("WEB");
            model.setIsSendWeb(true);
            model.setCategory(1);
            List<String> receive = new ArrayList<>();
            receive.add("system");
            model.setRecivers(receive);
            Token token = remoteSecurityService.getServerToken();
            systemctlFeign.create(token.getAppKey(), token.getProduct(), token.getToke(), model);
            QuartzManager.removeJob(jobName,jobGroupName,triggerName,triggerGroupName);
        } catch (Exception e) {
            log.error("稳压泵运行时常消息发送失败"+ e.getMessage());
        }
    }
}
