package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.SupervisionVideo;
import com.yeejoin.equipmanage.mapper.SupervisionVideoMapper;
import com.yeejoin.equipmanage.service.ISupervisionVideoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;


@Slf4j
@Service
//@EnableAsync
public class SupervisionVideoServiceImpl extends ServiceImpl<SupervisionVideoMapper, SupervisionVideo> implements ISupervisionVideoService {

    @Autowired
    SupervisionVideoMapper supervisionVideoMapper;

    @Override
    public List<List<Map<String, Object>>> queryVideoList(String bizOrgCode) {
        List<List<Map<String, Object>>> resList = new ArrayList<>();
        List<Map<String, Object>> list = supervisionVideoMapper.getVideoByCompany(bizOrgCode);
        List<Map<String, Object>> mapList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            if (list.size() > 1 && (i / 2) - 1 != 0 && i != 0) {
                mapList.add(list.get(i));
                resList.add(mapList);
                mapList = new ArrayList<>();
            } else {
                mapList.add(list.get(i));
                if (i == list.size() - 1) {
                    resList.add(mapList);
                }
            }
        }
        return resList;
    }

    @Override
    public int deleteVideo(String id) {
        return supervisionVideoMapper.delete(new QueryWrapper<SupervisionVideo>().eq("camera_id", id));
    }

    @Override
    public boolean addVide(String ids, String bizOrgCode) {
        List<SupervisionVideo> list = new ArrayList<>();
        for (String s : ids.split(",")) {
            SupervisionVideo supervisionVideo = new SupervisionVideo();
            supervisionVideo.setCameraId(s);
            supervisionVideo.setBizOrgCode(bizOrgCode);
            supervisionVideo.setId(Long.valueOf(String.valueOf(UUID.randomUUID().getLeastSignificantBits()).replace("-", "")));
            list.add(supervisionVideo);
        }
        return saveBatch(list);
    }

    @Override
    public List<Map<String, Object>> queryVideoAllId(String bizOrgCode) {
        return supervisionVideoMapper.queryVideoAllId(bizOrgCode);
    }
}
