package com.yeejoin.amos.boot.module.cylinder.api.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;

@Data
@Accessors(chain = true)
@Document(indexName = "cylinder_filling_info", shards = 6, replicas = 2)
public class ESCylinderFillingInfoDto {
    @Id
    private Long sequenceNbr;

    // 充装单位
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "充装单位名称")
    private String fillingUnitName;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "充装企业统一社会信用代码")
    private String fillingUnitCreditCode;

    // 出厂编号
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "出厂编号")
    private String factoryNum;

    // 气瓶品种code
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "气瓶品种代码")
    private String defineCode;

    // 气瓶品种名称
    @Field(type = FieldType.Text)
    @ApiModelProperty(value = "气瓶品种名称")
    private String defineName;

    // 二维码编号
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "二维码编号")
    private String qrCode;

    // 电子标签编号
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "电子标签编号")
    private String electronicLabelCode;

    // 气瓶唯一标识
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "气瓶唯一标识")
    private String sequenceCode;

    // 单位内部编号
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "单位内部编号")
    private String unitInnerCode;

    // 产权单位名称
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "产权单位名称")
    private String estateUnitName;

    //气瓶状态code
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "气瓶状态代码")
    private String cylinderStatus;

    //气瓶状态名称
    @Field(type = FieldType.Text)
    @ApiModelProperty(value = "气瓶状态名称")
    private String cylinderStatusName;

    // 气瓶类型 code
    @Field(type = FieldType.Text)
    @ApiModelProperty(value = "气瓶类型")
    private String cylinderTypeName;

    // 气瓶类型
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "气瓶类型代码")
    private String cylinderType;

    // 充装开始时间
    @Field(type = FieldType.Date, format = DateFormat.date_hour_minute_second)
    @ApiModelProperty(value = "充装开始时间")
    private String fillingStartTime;

    // 充装结束时间
    @Field(type = FieldType.Date, format = DateFormat.date_hour_minute_second)
    @ApiModelProperty(value = "充装结束时间")
    private String fillingEndTime;

    // 充装前检查Id
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "充装前检查Id")
    private String fillingBeforeId;

    // 作业人员证书编号
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "作业人员证书编号")
    private String inspectorUserNum;

    // 充装前检查人员姓名
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "充装前检查人员姓名")
    private String inspectorUser;

    @Field(type = FieldType.Date, format = DateFormat.date_hour_minute_second)
    @ApiModelProperty(value = "同步时间")
    private Date syncDate;

    // 同步状态0-新增 1-更新 2-删除
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "同步状态0-新增 1-更新 2-删除")
    private Integer syncState;

    // 对接公司编码appid
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "对接公司编码appid")
    private String appId;

    //行政区划代码
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "行政区划代码")
    private String regionCode;

    // 气瓶属地监管部门代码
    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "气瓶属地监管部门代码")
    private String orgBranchCode;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "气瓶属地监管部门")
    private String orgBranchName;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "充装枪编号")
    private String gunNumber;

    @Field(type = FieldType.Double)
    @ApiModelProperty(value = "充装量m³/(kg)")
    private Double fillingAmount;

    @Field(type = FieldType.Double)
    @ApiModelProperty(value = "压力")
    private Double pressure;

    @Field(type = FieldType.Double)
    @ApiModelProperty(value = "室温")
    private Double ambientTemperature;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "异常情况")
    private String abnormalConditions;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "瓶体温度无异常升高")
    private String isNoAbnormalTemperatureRise;

    @Field(type = FieldType.Double)
    @ApiModelProperty(value = "充装压力")
    private Double fillingPressure;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "瓶体温度一致")
    private String temperatureConsistent;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "瓶内无异常音响")
    private String noAbnormalSoundInside;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "瓶阀及各连接部位的密封良好")
    private String valveSealedWell;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "充装压力≤2.5 MPa")
    private String fillingPressureLessThan;

    @Field(type = FieldType.Double)
    @ApiModelProperty(value = "乙炔充装量")
    private Double acetyleneFillingAmount;

    @Field(type = FieldType.Keyword)
    @ApiModelProperty(value = "各组分含量")
    private Double componentContents;

    @Field(type = FieldType.Double)
    @ApiModelProperty(value = "标称皮重")
    private Double tareWeightNominal;

    @Field(type = FieldType.Double)
    @ApiModelProperty(value = "充装后质量")
    private Double filledWeight;

    @Field(type = FieldType.Double)
    @ApiModelProperty(value = "实际充装量")
    private Double actualFillingAmount;

    @Field(type = FieldType.Double)
    @ApiModelProperty(value = "含余气皮重")
    private Double tareWeightIncludingResidualGas;

    @Field(type = FieldType.Double)
    @ApiModelProperty(value = "上传数据完整度")
    private Double integrity;

    // 充装前检查信息
    @Field(type = FieldType.Nested)
    private BeforeCheck beforeCheck;

    // 充装后复查信息
    @Field(type = FieldType.Nested)
    private AfterCheck afterCheck;

    @Data
    public static class BeforeCheck {
        @Field(type = FieldType.Long)
        private Long sequenceNbr;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "作业人员证书编号")
        private String inspectorUserNum;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "作业人员姓名")
        private String inspectorUser;

        @Field(type = FieldType.Date, format = DateFormat.date_hour_minute_second)
        @ApiModelProperty(value = "检查时间")
        private Date inspectionDate;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "车牌号码")
        private String carNumber;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "充装气体与气瓶允许充装气体一致")
        private String isCylinderGasConsistent;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "充装介质")
        private String fillingMedium;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶外表面有划伤、裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷")
        private String hasSevereExternalDamage;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶内有剩余压力")
        private String hasResidualPressure;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "无气体泄漏")
        private String isGasLeak;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶附件齐全并符合安全要求")
        private String areAccessoriesCompleteAndSafe;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "排除超期未检气瓶、非法改装或翻新及报废气瓶")
        private String excludeOverdueRefurbishedScrappedCylinders;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "警示标签上印有的瓶装气体的名称及化学分子式应与气瓶钢印标志是否一致")
        private String isWarningLabelGasNameConsistentWithStamp;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶外表面的颜色标志是否符合规定")
        private String isColorMarkingCompliant;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶阀符合GB7512规定")
        private String valveCompliesGB7512;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶外表面无裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷")
        private String hasNoSevereExternalDamage;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "新投入使用气瓶或经检验后首次投入使用气瓶，充装前按照规定先置换瓶内空气，并经分析合格后方可充气")
        private String isNewOrInspectedOk;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "充装介质与气瓶钢印标志气体名称是否一致")
        private String isFillingMediumConsistentWithStamp;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶瓶阀的出气口螺纹型式是符合GB/T15383的规定")
        private String outletThreadTypeCompliesGB15383;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "充装可燃、氧化性气体，如无余压保持阀，重复充装前应先进行抽真空处理")
        private String isVacuumProcessed;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶外表面无严重腐蚀")
        private String hasNoSevereCorrosion;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶外表面无损伤缺陷")
        private String hasNoSurfaceDefects;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶外表面的颜色标志符合GB/T7144的规定、且清晰易认")
        private String colorMeetsGB7144;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶外表面无裂纹")
        private String hasNoCracks;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶外表面无明显变形")
        private String hasNoObviousDeformation;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶体、瓶阀无沾染油脂或其他可燃物")
        private String noOilOrFlammableSubstances;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶体无腐蚀、机械损伤等表面缺陷、是否满足GB13076标准报废")
        private String meetsGB13076AndMechanicalDamage;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "易熔合金无融熔、流失、损伤的")
        private String fusiblePlugUndamaged;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "钢印标记完整且能够识别")
        private String stampMarkingsClearAndComplete;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "附件完整且符合规定")
        private String accessoriesCompleteAndConforming;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶阀侧接嘴处积无炭黑或焦油等异物")
        private String noCarbonBlackOrTarAtValvePort;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶内的填料、溶剂的质量没有问题")
        private String fillerAndSolventQualityOK;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "无其他影响安全使用缺陷的")
        private String noOtherSafetyAffectingDefects;

        @Field(type = FieldType.Double)
        @ApiModelProperty(value = "充装间温度")
        private Double fillingRoomTemperature;

        @Field(type = FieldType.Double)
        @ApiModelProperty(value = "剩余压力")
        private Double residualPressure;

        @Field(type = FieldType.Double)
        @ApiModelProperty(value = "丙酮补加量")
        private Double acetoneSupplementAmount;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "钢印、警示标签与待充介质名称一致")
        private String isStampAndLabelConsistentWithMedium;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "外表面颜色标志符合规定")
        private String externalColorMarkingCompliant;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶阀出气口螺纹符合要求")
        private String valveOutletThreadComplies;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "外表面无严重损伤缺陷")
        private String hasNoSevereSurfaceDefects;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶附件符合要求")
        private String cylinderAccessoriesMeetRequirements;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "氧化性混合气体的瓶体、瓶阀未沾染油脂")
        private String oxidizingGasCylinderFreeOfOil;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶经预处理（抽真空、烘干、置换或组合）合格")
        private String preTreatedSuccessfully;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶表面无油污、无严重损伤")
        private String surfaceFreeOfOilAndDamage;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶阀完好、接头洁净无水或冰")
        private String valveInGoodConditionCleanConnection;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "无余压的瓶用洁净的待充气体吹扫（易燃的先用液氮置换）")
        private String emptyPressureCylinderPurgedWithCleanGas;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶阀出气口为内螺纹(左旋)")
        private String valveOutletInternalThreadLeftHanded;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "有余压的经定性鉴别且与待充介质一致")
        private String qualitativeTestPassedForResidualGas;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "无余压的经卸阀内检合格")
        private String internalValveInspectionPassed;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶安全附件齐全并符合安全要求")
        private String safetyAccessoriesCompleteAndSafe;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "首充气瓶已置换瓶内空气")
        private String newCylinderAirReplacedBeforeFirstUse;
    }

    @Data
    public static class AfterCheck {
        @Field(type = FieldType.Long)
        private Long sequenceNbr;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "作业人员证书编号")
        private String inspectorUserNum;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "作业人员姓名")
        private String inspectorUser;

        @Field(type = FieldType.Date, format = DateFormat.date_hour_minute_second)
        @ApiModelProperty(value = "检查时间")
        private Date inspectionDate;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶体未出现鼓包变形或泄漏等严重缺陷")
        private String isNoBulgingOrLeakage;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶内压力正常")
        private String isPressureNormal;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶体温度没有异常升高的迹象")
        private String isTemperatureNormal;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶阀及其与瓶口连接的密封良好")
        private String valveSealIsGood;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶粘贴警示标签和充装标签)")
        private String hasWarningAndFillingLabels;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "充装量复秤未超重")
        private String reweighedWithinLimit;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶内压力(充装量)及质量符合安全技术规范及相关标准的要求")
        private String pressureAndMassMeetRegulations;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶帽、充装标签、警示标签完整")
        private String capsAndLabelsAreIntact;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶阀出气口螺纹及其密封面良好")
        private String valveSealedWell;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "静置后压力符合规定")
        private String pressureAfterRestingComplies;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶未发生泄漏等问题")
        private String noLeakageIssuesDetected;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "处理结果是否合格")
        private String isTreatmentResultQualified;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "充装量（压力或质量）符合要求")
        private String fillingAmountMeetsRequirement;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "密封良好无泄漏")
        private String sealsIntactNoLeakage;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶无变形等缺陷")
        private String noDeformationOrDefects;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "瓶体温升无异常")
        private String temperatureRiseNormal;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶附件完整齐全")
        private String cylinderAccessoriesComplete;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "阀门已关闭,管路及各附件无漏气")
        private String valveClosedNoLeakageInPipingAndAccessories;

        @Field(type = FieldType.Keyword)
        @ApiModelProperty(value = "气瓶外观无结霜、结露")
        private String noFrostOrCondensationOnCylinder;
    }
}
